#!/usr/bin/env python
# In case of poor (Sh**y) commenting contact christopher.edelmaier@colorado.edu
# Basic
import sys, os, pdb
import gc
import argparse
import fnmatch
## Analysis
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import matplotlib as mpl

import scipy.io as sio

'''
Name: PandasCreator.py
Description:
Input:
Output:
'''

# Class definition
class PandasCreator(object):
    def __init__(self, name):
        self.cwd = os.getcwd()

        self.LoadData(name)

    # Read in the data from a specified location
    def LoadData(self, dataname):
        if dataname == 'klp5_6':
            self.LoadFromKlp56()
        elif dataname == 'wt':
            self.LoadFromWT()

    def LoadFromKlp56(self):
        self.experiment_datadir = os.path.join(os.path.dirname(os.path.realpath(__file__)), '..', 'Data', 'Klp56', 'MATLAB')
        out_dir = os.path.join(os.path.dirname(os.path.realpath(__file__)), '..', 'Data', 'Klp56', 'Pandas')
        listoffiles = os.listdir(self.experiment_datadir)
        pattern = '*.mat'
        experiments = []
        for entry in listoffiles:
            if fnmatch.fnmatch(entry, pattern):
                experiments += [os.path.join(self.experiment_datadir, entry)]

        dataLists = {}
        for experiment in experiments:
            track_names = os.path.basename(experiment).split('_')
            track_name = track_names[0] + '_' + track_names[1]
            raw_matlab = sio.loadmat(experiment, squeeze_me=True)

            # Get the particular MATLAB data
            lengthvec = raw_matlab['lengthvec']
            timevec   = raw_matlab['timevec']
            errorvec  = raw_matlab['errorvec']

            combined_data = {'time' : timevec,
                             'length' : lengthvec,
                             'error' : errorvec}
            df = pd.DataFrame(combined_data)
            dataLists[track_name] = df

            # Save off the pandas dataframe
            new_file = os.path.join(out_dir, track_name + '_pandas.pickle')
            df.to_pickle(new_file)
            new_csv = os.path.join(out_dir, track_name + '_pandas.csv')
            df.to_csv(new_csv)

    def LoadFromWT(self):
        print "Creating data from wild type files"
        self.experiment_datadir = os.path.join(os.path.dirname(os.path.realpath(__file__)), '..', 'Data', 'WT', 'MATLAB')
        out_dir = os.path.join(os.path.dirname(os.path.realpath(__file__)), '..', 'Data', 'WT', 'Pandas')
        listoffiles = os.listdir(self.experiment_datadir)
        pattern = '*.mat'
        experiments = []
        for entry in listoffiles:
            if fnmatch.fnmatch(entry, pattern):
                experiments += [os.path.join(self.experiment_datadir, entry)]

        dataLists = {}
        for experiment in experiments:
            track_names = os.path.basename(experiment).split('_')
            # Create the proper name, track-subtrack
            if len(track_names) == 8:
                track_name = 'track_' + track_names[5] + '-' + track_names[6]
            else:
                track_name = 'track_' + track_names[5]

            raw_matlab = sio.loadmat(experiment, squeeze_me=True)

            cell_data = raw_matlab['CellData']
            timevec   = cell_data[:,0]
            lengthvec = cell_data[:,1]
            lengtherr = cell_data[:,2]
            
            timevec_kc = cell_data[:,3]
            kc0_dist   = cell_data[:,4]
            kc0_err    = cell_data[:,5]
            kc1_dist   = cell_data[:,6]
            kc1_err    = cell_data[:,7]
            kc2_dist   = cell_data[:,8]
            kc2_err    = cell_data[:,9]
            kc3_dist   = cell_data[:,10]
            kc3_err    = cell_data[:,11]
            kc4_dist   = cell_data[:,12]
            kc4_err    = cell_data[:,13]
            kc5_dist   = cell_data[:,14]
            kc5_err    = cell_data[:,15]

            # Shift times to a common 0 to denote prometaphase onset
            zerotime = timevec[0]
            timevec = timevec - zerotime
            timevec_kc = timevec_kc - zerotime
            timevec = timevec / 60.0
            timevec_kc = timevec_kc / 60.0

            combined_data = {'time_length' : timevec,
                             'length' : lengthvec,
                             'length_error' : lengtherr,
                             'time_kc' : timevec_kc,
                             'kc0_dist' : kc0_dist,
                             'kc0_err' : kc0_err,
                             'kc1_dist' : kc1_dist,
                             'kc1_err' : kc1_err,
                             'kc2_dist' : kc2_dist,
                             'kc2_err' : kc2_err,
                             'kc3_dist' : kc3_dist,
                             'kc3_err' : kc3_err,
                             'kc4_dist' : kc4_dist,
                             'kc4_err' : kc4_err,
                             'kc5_dist' : kc5_dist,
                             'kc5_err' : kc5_err}

            df = pd.DataFrame(combined_data)

            # Print out the data
            new_csv = os.path.join(out_dir, track_name + '_pandas.csv')
            df.to_csv(new_csv)




##########################################
if __name__ == "__main__":
    x = PandasCreator(sys.argv[1])
