#!/usr/bin/env python
## Basic
import sys
import os
import pdb
import gc
## Advanced
import numpy as np
import matplotlib.pyplot as plt

class CorrelationData():
    def __init__(self, run_dir, filename):
        self.run_dir = run_dir
        self.filename = os.path.join(self.run_dir, filename)
        self.mfile = open(self.filename, 'rb')
        self.ReadData()

    def Print(self):
        print "ndim: {}".format(self.ndim)
        print "nbin: {}".format(self.nbin)
        print "h: {}".format(self.h)
        print "nlinear: {}".format(self.nlinear)
        print "dist: {}".format(self.dist)
        print "bin_size: {}".format(self.bin_size)

    def ReadData(self):
        self.ndim = np.fromfile(self.mfile, dtype=np.int32, count=1)[0]
        nbindt = np.dtype([
            ('nbin', np.int32, self.ndim),
        ])
        nbinf = np.fromfile(self.mfile, dtype=nbindt, count=1)[0]
        self.nbin = nbinf['nbin']
        hdt = np.dtype([
            ('h', np.float64, (self.ndim,self.ndim)),
        ])
        hf = np.fromfile(self.mfile, dtype=hdt, count=1)[0]
        self.h = hf['h']
        self.nlinear = np.fromfile(self.mfile, dtype=np.int32, count=1)[0]
        #self.nlinear = 1
        #for nb in self.nbin:
        #    self.nlinear = self.nlinear * nb
        nlineardt = np.dtype([
            ('dist', np.float64, self.nlinear),
        ])
        nlinearf = np.fromfile(self.mfile, dtype=nlineardt, count=1)[0]
        self.dist = nlinearf['dist']

        # Generate the bin size
        self.bin_size = self.h/self.nbin

    def GetData(self):
        if self.ndim == 2:
            imagedata = np.reshape(self.dist, (self.nbin[0], self.nbin[1]))
        else:
            imagedata = self.dist
        return imagedata

    # Normalize the data
    def NormalizeData(self):
        if self.ndim == 2:
            print "not able to normalize 2d data yet...."
            sys.exit(1)
        else:
            self.norm_data = self.dist / (np.sum(self.dist) * self.bin_size[0])
        return self.norm_data

    def PlotData(self, dataname, scale = 1.0):
        if self.ndim == 2:
            self.Plot2dData(dataname, scale)
        else:
            imagedata = self.dist
            plt.plot(imagedata)
            filename = '{}.png'.format(dataname)
            plt.savefig(filename, bbox_inches='tight')

    def Plot2dData(self, dataname, scale):
        imagedata = np.reshape(self.dist, (self.nbin[0], self.nbin[1]))
        imagedata = imagedata
        plt.imshow(imagedata[:,:])
        filename = '{}.png'.format(dataname)
        plt.savefig(filename, bbox_inches='tight')

if __name__ == "__main__":
    run_dir = sys.argv[1]
    filename = sys.argv[2]
    cdata = CorrelationData(run_dir, filename)
    cdata.Print()
    cdata.PlotData('moomoo')
