#include "bob.h"
#include "kinetochore.h"
#include "chromosome_management.h"

#include <iostream>

double af_mt_harmonic_potential(system_parameters *parameters,
                                system_properties *properties, double **f_bond,
                                double **virial, double **t_bond, int *calc_matrix) {
    // Shortcuts
    Kinetochore *kcs = properties->chromosomes.kinetochores_;
    int nkcs = properties->chromosomes.nkcs_;
    int ndim = parameters->n_dim;
    int nbonds = properties->bonds.n_bonds;
    double **f_kc = properties->chromosomes.f_;
    double **t_kc = properties->chromosomes.t_;

    // Zero out forces, etc
    memset(f_bond[0], 0, nbonds * ndim * sizeof(double));
    memset(t_bond[0], 0, nbonds * 3 * sizeof(double));
    if (properties->control.virial_flag)
        memset(virial[0], 0, ndim * ndim * sizeof(double));
    double u = 0.0;

    // Loop over kinetochores
    for (int ikc = 0; ikc < nkcs; ++ikc) {
        // Loop over sites
        Kinetochore *kc = &(kcs[ikc]);
        int nsites = kc->nsites_;
        for (int isite = 0; isite < nsites; ++isite) {
            if (kc->attach_[isite] == -1)
                continue;

            int ibond = kc->attach_[isite];
            //std::cout << "Found a bound one!\n";
            //kc->PrintFrame();
            //std::cout << "MT r("
            //    << properties->bonds.r_bond[ibond][0] << ", "
            //    << properties->bonds.r_bond[ibond][1] << ", "
            //    << properties->bonds.r_bond[ibond][2] << ")\n";
            //std::cout << "MT u("
            //    << properties->bonds.u_bond[ibond][0] << ", "
            //    << properties->bonds.u_bond[ibond][1] << ", "
            //    << properties->bonds.u_bond[ibond][2] << ")\n";

            //std::cout << "AF MT harmonic KC[" << ikc << "]{" << isite << "}, bond: " << ibond << std::endl;

            double flink[3] = {0.0};
            double tlink[3] = {0.0};
            u += kc->CalcForceHarmonic(parameters->n_dim,
                                       parameters->n_periodic,
                                       properties->unit_cell.h,
                                       isite,
                                       properties->bonds.r_bond[ibond],
                                       properties->bonds.s_bond[ibond],
                                       properties->bonds.u_bond[ibond],
                                       properties->bonds.length[ibond],
                                       flink,
                                       tlink);

            // Add the forces
            for (int i = 0; i < ndim; ++i) {
                f_kc[ikc][i] += flink[i];
                f_bond[ibond][i] -= flink[i];
            }

            // Virial contributions
            //Use the center-to-center separation of this
            if (properties->control.virial_flag) {
                double r_cm[3] = {0.0};
                for (int i = 0; i < parameters->n_dim; ++i) {
                    r_cm[i] = kc->r_[i] - properties->bonds.r_bond[ibond][i];
                }
                for (int i = 0; i < parameters->n_dim; ++i) {
                    for (int j = 0; j < parameters->n_dim; ++j) {
                        //virial[i][j] -= kc->r_cross_[isite][i] * flink[j];
                        virial[i][j] += r_cm[i] * flink[j];
                    }
                }
            }


            //if (properties->i_current_step >= 3021134) {
            //    std::cout << "AF MT Current forces:\n";
            //    std::cout << "  KC[" << ikc << "] site[" << isite << "] bond[" << ibond << "]\n";
            //    std::cout << "  flink: (" << flink[0] << ", " << flink[1] << ", " << flink[2] << ")\n";
            //    std::cout << "  fkc:   (" << f_kc[ikc][0] << ", " << f_kc[ikc][1] << ", " << f_kc[ikc][2] << ")\n";
            //    std::cout << "  fbond: (" << f_bond[ibond][0] << ", " << f_bond[ibond][1] << ", " << f_bond[ibond][2] << ")\n";
            //    exit(1);
            //}

            // Calculate torques
            double rcontact_i[3] = {0.0};
            double rcontact_j[3] = {0.0};
            double mu = kc->cross_pos_[isite] - 0.5 * properties->bonds.length[ibond];
            for (int i = 0; i < ndim; ++i) {
                // The anchor position minus the middle of the kinetochore
                rcontact_i[i] = properties->chromosomes.anchors_[ikc][isite].pos[i] - kc->r_[i];
                rcontact_j[i] = properties->bonds.u_bond[ibond][i] * mu;
            }
            double tau[3] = {0.0};
            cross_product(rcontact_i, flink, tau, ndim);
            for (int i = 0; i < 3; ++i) {
                t_kc[ikc][i] += tau[i];
            }
            // The kinetochore has an additional torque from the orientation dependent effects too!
            for (int i = 0; i < 3; ++i) {
                t_kc[ikc][i] += tlink[i];
            }

            cross_product(rcontact_j, flink, tau, ndim);
            for (int i = 0; i < 3; ++i) {
                t_bond[ibond][i] -= tau[i];
            }

            calc_matrix[ibond] = 1;

            // Step?
            kc->Step(parameters->n_dim,
                     parameters->n_periodic,
                     properties->bonds.n_bonds,
                     properties->unit_cell.h,
                     properties->bonds.r_bond,
                     properties->bonds.s_bond,
                     properties->bonds.u_bond,
                     properties->bonds.length,
                     parameters->delta,
                     properties->rng.r); 
            if (u != u) {
                std::cerr << "NaN encountered in af_mt_harmonic_potential\n";
                std::cerr << "Step: " << properties->i_current_step << std::endl;
                std::cerr << "Kinetochore[" << ikc << "], bond[" << ibond << "]\n";
            }
        }
    }

    return u;
}
