#include "bob.h"

// Anchor LJ12-6 potential to make the SPBs slightly 'sticky' with one another
// where now an epsilon describes the number of factors of kBT that are included
// which controls the potential depth, and sigma now controls the characteristic 
// distance of this effect
double anchor_lj_potential_bd(system_parameters *parameters,
                               system_properties *properties,
                               double **f_bond, double **virial,
                               double **t_bond, int *calc_matrix) {
    const double four_epsilon = 4.0 * properties->anchors.spb_interaction_strength;
    
    /* Zero vdw forces, potential energy and virial. */
    double u = 0.0;
    if (properties->control.virial_flag)
        memset(virial[0], 0, SQR(parameters->n_dim) * sizeof(double));
    
    for (int i_anchor = 0;
         i_anchor < properties->anchors.n_anchors - 1;
         ++i_anchor) {
        for (int j_anchor = i_anchor + 1;
             j_anchor < properties->anchors.n_anchors;
             ++j_anchor) {
            double dr_mag2 = 0.0; double dr[3];
            for (int i = 0; i < parameters->n_dim; ++i) {
                dr[i] = properties->anchors.r_anchor[j_anchor][i] -
                    properties->anchors.r_anchor[i_anchor][i];
                dr_mag2 += SQR(dr[i]);
            }

            double d_eff = properties->anchors.spb_interaction_range;
            double d_eff2 = SQR(d_eff);
            double dr_mag = sqrt(dr_mag2);
            double scale =
                (0.5 * (properties->anchors.diameter[i_anchor] +
                        properties->anchors.diameter[j_anchor]) -
                 d_eff) / dr_mag;

            dr_mag2 = 0.0;
            for (int i = 0; i < parameters->n_dim; ++i) {
                dr[i] -= scale * dr[i];
                dr_mag2 += SQR(dr[i]);
            }
            
            /* Add contributions to potential energy and forces. */
            double rho2 = d_eff2 / dr_mag2;
            double rho6 = CUBE(rho2);
            double rho12 = SQR(rho6);
            
            double factor = 6.0 * four_epsilon * (2.0 * rho12 - rho6) / dr_mag2;
            for (int i = 0; i < parameters->n_dim; ++i) {
                properties->anchors.f_anchor[i_anchor][i] -= factor * dr[i];
                properties->anchors.f_anchor[j_anchor][i] += factor * dr[i];
            }

            u += four_epsilon * (rho12 - rho6);

            // Add contribution to virial
            if (properties->control.virial_flag) {
                for (int i = 0; i < parameters->n_dim; ++i) {
                    for (int j = 0; j < parameters->n_dim; ++j) {
                        virial[i][j] += dr[i] * factor * dr[j];
                    }
                }
            }
        }
    }

    return u;
}
