/* This routine calculates the scaled and real positions of a bond.
 
 Input: number of spatial dimensions (n_dim)
 number of periodic dimensions (n_periodic)
 unit cell matrix (h)
 inverse unit cell matrix (h_inv)
 array of real site positions (r)
 label of first bond endpoint (site_1)
 bond_vectors (v_bond)
 
 Output: real bond position (r_bond)
 scaled bond position (s_bond) */

#include "bob.h"

void bond_position(int n_dim, int n_periodic, double **h, double **h_inv,
                   double **r, int site_1, double *v_bond, double *r_bond, double *s_bond)
{
    int i, j;

    /* Compute real position of center of bond. */
    for (i = 0; i < n_dim; ++i)
        r_bond[i] = r[site_1][i] + 0.5 * v_bond[i];

    /* Compute scaled bond position and apply periodic boundary conditions if necessary. */
    for (i = 0; i < n_periodic; ++i) {
        s_bond[i] = 0.0;
        for (j = 0; j < n_periodic; ++j)
            s_bond[i] += h_inv[i][j] * r_bond[j];
        s_bond[i] -= NINT(s_bond[i]);
    }

    /* Recompute real coordinates accounting for periodic boundary conditions. */
    for (i = 0; i < n_periodic; ++i) {
        r_bond[i] = 0.0;
        for (j = 0; j < n_periodic; ++j)
            r_bond[i] += h[i][j] * s_bond[j];
    }

    return;
}
