#ifndef _CELL_LIST_H
#define _CELL_LIST_H

#include "allocate.h"

/* The <cell_list> structure contains variables and arrays associated with cell lists. */
class cell_list {
 private:
    int n_linear_hold,             /* Number of cells allocated. */
        n_objects,                 /* Number of total objects tracked by system */
        n_objects_hold,            /* Number of objects allocated in memory. */
        n_dim,                     /* Number of dimensions.  */
        n_shell,                   /* Number of cells per interaction distance */
        n_periodic;                /* Number of dimensions to use periodic boundary conditions.  */

 public:
    int n_cells[3],               /* Array containing the number of cells along each dimension. */
        n_linear,                  /* Total number of cells. */
        *cell,                      /* Array of cell labels for each site. */
        *head,                      /* Array of labels of first site in each cell. */
        *tail,                      /* Array of labels of last site in each cell. */
        *prev,                      /* Array of labels of previous site in cell. */
        *next,                      /* Array of labels of next site in cell. */
        *n_search_half,             /* Array of number of cells in half search domain of each cell. */
        **search_cell_half,         /* Array of labels of cells in half search domain of each cell. */
        ***shift_cell_half,         /* Array of cell shifts for applying periodic boundary conditions (half space). */
        *n_search_full,             /* Array of number of cells in full search domain of each cell. */
        **search_cell_full,         /* Array of labels of cells in full search domain of each cell. */
        ***shift_cell_full;         /* Array of cell shifts for applying periodic boundary conditions (full space). */

    double r_cutoff_max;        /* Maximum interaction cutoff distance (minimum cell dimension). */

    cell_list();
    
    cell_list(int n_dim, int n_periodic, int n_objects, double r_cutoff_max, double **s, double *a_perp);

    void init(int n_dim, int n_periodic, int n_objects, double r_cutoff_max, double **s, double *a_perp);
    
    void init_cell_lists(double **s);

    void init_cell_structure(int init_flag, double **s);
    
    int cell_index(double *s);

    void cell_search_list(int half_flag, int i_dim, int *i_cell, int *j_cell, int *shift);

    void add_cell_entry(int i_object, int i_linear);

    int check_cell_lists(int n_objects, double *a_perp, double **s_object, double r_cutoff);

    void remove_cell_entry(int i_object, int i_linear);

    void update_cell_lists(double **s);

    void update_cell_lists_single(int i_object, double *s);

    int linear_index(int i_dim, int n_dim, int *i_grid, int *n_grid);

    void number_of_cells(double *a_perp);

};
#endif
