/* Check if the neighbor lists need to be updated and if so, do it. 

   Input: pointer to parameters structure (parameters)
          pointer to properties structure (properties)

   Output: updated neighbor lists are returned if needed. */

#include "bob.h"

int check_neighbor_lists_sphero(system_parameters * parameters, system_properties * properties)
{
    int n_dim, n_sites, nl_flag, i, i_site;
    double skin, **dr_tot, half_skin2, dr2;

    /* Set up shortcuts to data structures. */
    n_dim = parameters->n_dim;
    skin = parameters->skin;
    n_sites = properties->sites.n_sites;
    dr_tot = properties->sites.dr_tot;
    nl_flag = 0;

    /* Compute various constants. */
    half_skin2 = SQR(0.5 * skin);

    /* Loop over sites */
    for (i_site = 0; i_site < n_sites; ++i_site) {

        /* Compute total displacement since last neighbor list update. */
        dr2 = 0.0;
        for (i = 0; i < n_dim; ++i)
            dr2 += SQR(dr_tot[i_site][i]);

        /* Check if the site has moved a distance greater than half the
           skin of the neighbor list since last update. */
        nl_flag = dr2 > half_skin2;
        if (nl_flag)
            break;
    }

    if (nl_flag) {
        update_neighbor_lists_sphero(parameters, properties);
    } 
                                               
    return nl_flag;
}
