#include "bob.h"
#include "kinetochore.h"

#include <iostream>

double chromosome_chromatin_potential_angular(system_parameters *parameters, system_properties *properties,
                           double **f_bond, double **virial, double **t_bond, int *calc_matrix) {

    std::cout << "DEPRECATED IN FAVOR of complicated main potential, do not use!\n";
    exit(1);

    int nchromosomes, n_dim, n_bonds;
    double u, k;
    double dr[3];
    double costheta;
    double theta;
    double nhat[3] = {0.0};
    double nhatnorm;
    double tau_factor;
    double **f_chromosome;
    double **t_chromosome;
    double **r_kc;
    double **u_kc;
    double **v_kc;

    // Setup pointers to stuff
    nchromosomes = properties->chromosomes.nchromosomes_;
    n_dim = parameters->n_dim;
    f_chromosome = properties->chromosomes.f_;
    t_chromosome = properties->chromosomes.t_;
    r_kc = properties->chromosomes.r_;
    u_kc = properties->chromosomes.u_;
    v_kc = properties->chromosomes.v_;
    n_bonds = properties->bonds.n_bonds;
   
    // Legacy, always have to zero out the bond forces
    u = 0.0;
    if (properties->control.virial_flag)
        memset(virial[0], 0, n_dim * n_dim * sizeof(double));
    memset(f_bond[0], 0, n_bonds * n_dim * sizeof(double));
    memset(t_bond[0], 0, n_bonds * 3 * sizeof(double));

    // The chromosomes have to be found first, since we do this based on their midsection point for the
    // u vector, and then just try to align the v vectors along with this
    // FIXME should use dihedral bond instead?
    k = properties->chromosomes.chromatin_ktor_;
    for (int ic = 0; ic < nchromosomes; ++ic) {
        // Find the director of the chromosome, note backwards from expected (points from 1 to 0, not the other way)
        double udir[3] = {0.0};
        for (int i = 0; i < n_dim; ++i) {
            udir[i] = r_kc[2*ic][i] - r_kc[2*ic+1][i];
        }
        double udirnorm = sqrt(dot_product(n_dim, udir, udir));
        for (int i = 0; i < n_dim; ++i) {
            udir[i] = udir[i] / udirnorm;
            std::cout << "udir: " << udir[i] << std::endl;
        }

        // kc0
        costheta = dot_product(n_dim, udir, u_kc[2*ic]);
        if (costheta > 1.0) costheta = 1.0;
        else if (costheta < -1.0) costheta = -1.0;
        theta = acos(costheta);
        std::cout << "costheta: " << costheta << std::endl;
        std::cout << "theta: " << theta << std::endl;
        cross_product(udir, u_kc[2*ic], nhat, n_dim);
        tau_factor = -theta * k;
        nhatnorm = sqrt(dot_product(n_dim, nhat, nhat));
        if (nhatnorm <= 0.0) nhatnorm = 1.0;
        for (int i = 0; i < n_dim; ++i) {
            nhat[i] = nhat[i] / nhatnorm;
        }

        std::cout << "kc0: theta: " << theta << std::endl;
        std::cout << "kc0: tau_factor: " << tau_factor << std::endl;
        std::cout << "kc0: nhat: (" << nhat[0] << ", " << nhat[1] << ", " << nhat[2] << ")\n";
    }

    std::cout << "DEBUG, exiting\n";
    exit(1);
   
    // They always come in pairs
    for (int ic = 0; ic < nchromosomes; ++ic) {
        k = properties->chromosomes.chromatin_ktor_;

        double tau[3] = {0.0};
        double nhat[3] = {0.0};
        double dot_prod = dot_product(n_dim, u_kc[2*ic], u_kc[2*ic+1]);
        if (dot_prod > 1.0) dot_prod = 1.0; // Have to bound in case of small addition errors, ugh
        else if (dot_prod < -1.0) dot_prod = -1.0;
        double theta = acos(dot_prod);
        cross_product(u_kc[2*ic], u_kc[2*ic+1], nhat, n_dim);
        double tau_factor = -theta * k;
        double nhatnorm = dot_product(n_dim, nhat, nhat);
        if (nhatnorm <= 0.0) nhatnorm = 1.0;
        for (int i = 0; i < 3; ++i) {
            nhat[i] = nhat[i] / sqrt(nhatnorm);
        }
   
        //std::cout << "theta: " << theta << std::endl;
        //std::cout << "tau_factor: " << tau_factor << std::endl;
        //std::cout << "nhat: (" << nhat[0] << ", " << nhat[1] << ", " << nhat[2] << ")\n";

        for (int i = 0; i < n_dim; ++i) {
            t_chromosome[2*ic  ][i] -= tau_factor * nhat[i];
            t_chromosome[2*ic+1][i] += tau_factor * nhat[i];
        }

        u += 0.5 * k * theta * theta;

        if (u != u) {
            std::cerr << "NaN encountered in chromosome_chormatin_potential\n";
            std::cerr << "Step: " << properties->i_current_step << std::endl;
            std::cerr << "Kinetochore pair: " << ic << "(" << properties->chromosomes.kinetochores_[2*ic].cidx_ << ") ["
                << properties->chromosomes.kinetochores_[2*ic].idx_ << ", " << properties->chromosomes.kinetochores_[2*ic+1].idx_ << "]\n";
        }
    }

    return u;
}
