#ifndef _CORRELATION_DATA_H
#define _CORRELATION_DATA_H
#include <vector>
#include <string>

class CorrelationData {
 public:
    
 private:
    int n_dim_;
    int n_linear_;
    long int n_meas_;
    
    std::vector<int> n_bin_;
    std::vector<double> h_;
    std::vector<double> h_inv_;
    std::vector<double> min_;
    std::vector<double> s_axis_;
    std::vector<int> i_bin_;

    std::vector<double> bin_size_;
    std::vector<double> dist_;

 public:
    void Init(int n_dim, double bin_size[], double min[], double max[]);
    void BinAxis(int n_dim, double r[], double u_frame[], double value);
    void Print();
    void Bin(int n_dim, double r[], double value);
    void IncrementBin(double value);
    void NormalizeByConstant(double norm_factor);
    void NormalizeSumUnity();
    void NormalizeNmeas();
    void OutputBinary(std::string outfile);
    void Fill(int size, double *data);
    inline void IncrementMeasCounter() {n_meas_++;};
    
 private:
    int LinearIndex();
    
};

#endif
