/* This routine computes the determinant of a square matrix.

   Input: size of square matrix (n)
          matrix for which to compute determinant (a)

   Output: determinant (return value) */

#include "bob.h"

double determinant(int n, double **a)
{
    int i, j, *index;
    double **a_shift, d;

    /* Allocate memory for local arrays. */
    a_shift = dmatrix(1, n, 1, n);
    index = ivector(1, n);

    /* Shift matrix to employ Numerical Recipes convention. */
    for (i = 1; i <= n; ++i)
        for (j = 1; j <= n; ++j)
            a_shift[i][j] = a[i - 1][j - 1];

    /* Use LU decomposition to compute determinant. */
    ludcmp(a_shift, n, index, &d);
    for (i = 1; i <= n; ++i)
        d *= a_shift[i][i];

    /* Free memory. */
    free_ivector(index, 1, n);
    free_dmatrix(a_shift, 1, n, 1, n);

    /* Return determinant. */
    return d;
}
