// Diffusion analysis of free particles, both spheres and spheros
// For some periodic boundary conditions

#include "bob.h"
#include <sys/time.h>
#include "diffusion_properties.h"
#ifndef NOGRAPH
#include "graphics.h"
#endif

#include <iostream>

// Main program
int main(int argc, char *argv[]) {
    system_parameters parameters;
    system_properties properties;
    system_potential potential;
    FILE *f_posit;
    char default_file[F_MAX];
    int n_dim, n_steps, n_posit, n_thermo, n_graph, graph_flag;
    double **h, **r, **s, **ra, **ua;

    if (argc != 2) {
        std::cout << "Usage: " << argv[0] << " default_file\n";
        exit(1);
    }
    strcpy(default_file, argv[1]);

    // Read the default parameters
    parse_parameters(default_file, &parameters);

    // Run the init_diffusion free code to not turn on interactions
    init_diffusion_analysis_free(&parameters, &properties, &potential);

    n_dim = parameters.n_dim;
    n_steps = parameters.n_steps;
    n_posit = parameters.n_posit;
    n_thermo = parameters.n_thermo;
    n_graph = parameters.n_graph;
    graph_flag = parameters.graph_flag;
    h = properties.unit_cell.h;
    r = properties.sites.r;
    s = properties.sites.s;
    ra = properties.anchors.r_anchor;
    ua = properties.anchors.u_anchor;

    #ifndef NOGRAPH
    /* Activate graphics if graph_flag == 1. */
    Graphics graphics;
    if (graph_flag == 1) {
        graphics.Init(&parameters, parameters.n_dim,
                      properties.unit_cell.h, 0);
        graphics.ResizeWindow(800,800);
        graphics.SetBoundaryType("cube");
        graphics.DrawLoop(properties.bonds.n_bonds,
                          properties.unit_cell.h,
                          properties.bonds.r_bond,
                          properties.bonds.u_bond,
                          properties.bonds.length,
                          properties.sites.n_sites,
                          properties.sites.r,
                          parameters.sphere_diameter);
    }
    #endif

    f_posit = gfopen("diffusion_analysis_free.posit" ,"w");
    //f_thermo = gfopen("diffusion_analysis_free.thermo", "w");

    properties.write_header_func(&parameters, &properties, f_posit);

    //DiffusionProperties diffusion(parameters.n_dim,
    //                              properties.bonds.n_bonds,
    //                              1,
    //                              properties.bonds.r_bond,
    //                              properties.bonds.u_bond);

    // Run the simulation
    for (int istep = 0; istep < n_steps; ++istep) {
        properties.time += parameters.delta;
        properties.i_current_step = istep;

        // Run a KC KMC cycle
        properties.chromosomes.StepKMC(&parameters, &properties);

        // Position step without any other stuff should just run
        // without potentials
        position_step_spindle_bd_mp(&parameters, &properties, &potential);

        #ifndef NOGRAPH
        /* Display configuration. */
        if (graph_flag && istep % n_graph == 0) {
            graphics.Draw(properties.bonds.n_bonds,
                          properties.unit_cell.h,
                          properties.bonds.r_bond,
                          properties.bonds.u_bond,
                          properties.bonds.length,
                          properties.crosslinks.n_types_,
                          properties.crosslinks.stage_0_xlinks_,
                          properties.crosslinks.stage_1_xlinks_,
                          properties.crosslinks.stage_2_xlinks_,
                          properties.anchors.n_anchors,
                          properties.anchors.color_,
                          properties.anchors.r_anchor,
                          properties.anchors.diameter,
                          properties.chromosomes.nchromosomes_,
                          &properties.chromosomes);
        }
        #endif
        if (istep % n_posit == 0) {
            update_bond_site_positions_mp(n_dim, parameters.n_periodic, properties.bonds.n_bonds,
                                          properties.sites.n_sites, h, properties.unit_cell.h_inv,
                                          properties.bonds.bond_site_1, properties.bonds.bond_site_2,
                                          properties.bonds.r_bond, properties.bonds.u_bond, properties.bonds.
                                          length, r, properties.sites.s);
            write_positions_spb_dynamics(n_dim,
                                         properties.sites.n_sites,
                                         properties.bonds.n_bonds,
                                         properties.anchors.n_anchors, 
                                         h, r, ra, ua,
                                         properties.time, f_posit);
            properties.chromosomes.WriteState(&parameters, &properties);
            //diffusion.Update(properties.bonds.r_bond,
            //                 properties.bonds.u_bond,
            //                 0);
        }
    }

    std::cout << "Successful run!\n";

    return 0;
}
