#ifndef _DIFFUSION_PROPERTIES_H
#define _DIFFUSION_PROPERTIES_H
#include <gsl/gsl_eigen.h>

typedef struct { 
    double vector[3];
    double value;
} eigensystem;

class DiffusionProperties {
 public:
    int n_dim_;
    int n_objs_;
    double op_tensor_[9];
    double op_tensor_curr_[9];
    int n_points_;
    
    int curr_point_;

    int *n_measurements_;
    double *r_mol_avg2_;
    double *r_mol_par_avg2_;
    double *r_mol_perp_avg2_;
    double *ui_dot_u0_;
    double *theta2_;

    double **u_0_;
    double **u_old_;
    double **dr_;
    double **r_0_;
    double *theta_;

    std::vector<double> ddf_x_;
    std::vector<double> ddf_y_;

    gsl_vector *eval_;
    gsl_matrix *evec_;
    gsl_eigen_symmv_workspace *w_;

    eigensystem director_;

    DiffusionProperties(int n_dim, int n_objs, int n_blocks_max,
                        double **r, double **u);

    void Update(double **r_obj,
                double **u_obj,
                int init_flag);

    eigensystem CalcDirectorOrderParameter(double *op_tensor);

    void Update_OP_Tensors(double **u_obj);

    void Calc_OP_Tensor(double **u_obj);

    eigensystem GetAverageDirector();

    eigensystem GetCurrentDirector();

    void FinalizeDirector();

    void OutputMSD(double delta_frame, int n_configs, const char* filename);

};

#endif
