// Ability to dump the state of the simulation given properties and parameters if something has gone wrong, and
// we call this function

#include "bob.h"

#include <iostream>
#include <iomanip>

void dump_simulation(system_parameters *parameters,
                     system_properties *properties,
                     std::string error_string) {
    FILE *f_posit;

    std::cout << "Dump simulation: " << error_string << std::endl;
    std::cout << "   step: " << properties->i_current_step << std::endl;

    f_posit = gfopen("dump_simulation.posit", "w");
    properties->write_header_func(parameters, properties, f_posit);

    // Hardcoded for spb_dynamics at the moment (spindle as well)
    update_bond_site_positions_mp(parameters->n_dim,
                                  parameters->n_periodic,
                                  properties->bonds.n_bonds,
                                  properties->sites.n_sites,
                                  properties->unit_cell.h,
                                  properties->unit_cell.h_inv,
                                  properties->bonds.bond_site_1,
                                  properties->bonds.bond_site_2,
                                  properties->bonds.r_bond,
                                  properties->bonds.u_bond,
                                  properties->bonds.length,
                                  properties->sites.r,
                                  properties->sites.s);
    write_positions_spb_dynamics(parameters->n_dim,
                                 properties->sites.n_sites,
                                 properties->bonds.n_bonds,
                                 properties->anchors.n_anchors,
                                 properties->unit_cell.h,
                                 properties->sites.r,
                                 properties->anchors.r_anchor,
                                 properties->anchors.u_anchor,
                                 properties->time,
                                 f_posit);

    properties->chromosomes.WriteState(parameters,
                                       properties,
                                       "dump_chromosome.posit");

    // Don't exit automatically, in case we need to collect more information
}
