/* This routine calculates the molecular dynamics efficiency, defined as the
   simulation time per cpu second.

   input: optimization interval (n_opt)
          integration timestep (delta)
          elapsed cpu time since last calculation of md efficiency (elapsed_time)

   output: efficiency (return value) */

#include "bob.h"

double dynamics_efficiency(int n_opt, double delta, double elapsed_time)
{
    double efficiency;

    /* Calculate efficiency, defined as the simulation time per cpu second. */
    efficiency = n_opt * delta / elapsed_time;

    return efficiency;
}
