/* Error handling routine. Used exactly like printf. */

#include "bob.h"
#include <stdarg.h>

void error_exit(const char *error_msg, ...) {
    va_list args;

    va_start (args, error_msg);
    /* Print error message to standard output and exit. */
    vfprintf (stderr, error_msg, args);
    va_end (args);
  
    exit(1);
}
