#ifndef _GEN_CHROMOSOMES_DIFFUSION_H_
#define _GEN_CHROMOSOMES_DIFFUSION_H_

#include "bob.h"
#include "test_module_base.h"

class GenChromosomesDiffusion : public TestModuleBase {
  public:
    GenChromosomesDiffusion() : TestModuleBase() {}
    virtual ~GenChromosomesDiffusion() {}

    virtual void RunTests();
    virtual void SetTests();

    bool TestForceTorqueBalance(double uret, bool print_info = true);

    bool GenDiffusion(); // basic test

    void InitSystem(); // Initialize what we need for the system

    std::string testfile_;
    long seed_ = 0;
    int nmts_ = 0;
    int ndim_ = 3;
    int nsteps_ = 0;
    int nposit_ = 0;

    // Record off kinetochore information because we need to be
    // able to test it against the force balance
    double rlastA[3] = {0.0};
    double rlastB[3] = {0.0};

    // Deltas needed for later
    double rA[3] = {0.0};
    double uA[3] = {0.0};
    double vA[3] = {0.0};
    double wA[3] = {0.0};
    double rB[3] = {0.0};
    double uB[3] = {0.0};
    double vB[3] = {0.0};
    double wB[3] = {0.0};


    system_parameters parameters_;
    system_properties properties_;
    system_potential potential_;
};

#endif
