#ifndef _GEN_CHROMOSOMES_PARTITION_H_
#define _GEN_CHROMOSOMES_PARTITION_H_

#include "bob.h"
#include "test_module_base.h"

class GenChromosomesPartition : public TestModuleBase {
  public:
    GenChromosomesPartition() : TestModuleBase() {}
    virtual ~GenChromosomesPartition() {}

    virtual void RunTests();
    virtual void SetTests();

    bool TestForceTorqueBalance(double uret, bool print_info = true);
    bool TestDeltas();

    bool GenBasic(); // basic test
    bool GenTip(); // tip enhancement test

    void InitSystem(); // Initialize what we need for the system

    std::string testfile_;
    long seed_ = 0;
    int nmts_ = 0;
    int ndim_ = 3;
    int nsteps_ = 0;

    // We are going to need access to potentials
    double **f_comp_;
    double **t_comp_;
    int *calc_matrix_;

    // Deltas needed for later
    double rA[3] = {0.0};
    double uA[3] = {0.0};
    double vA[3] = {0.0};
    double wA[3] = {0.0};
    double rB[3] = {0.0};
    double uB[3] = {0.0};
    double vB[3] = {0.0};
    double wB[3] = {0.0};


    system_parameters parameters_;
    system_properties properties_;
};

#endif
