#include "bob.h"

void generate_body_frame(int n_dim, double *u, double *body_frame) {
    int i;
    double norm_factor;
    double vect1[3] = { 1.0, 0, 0.0 };
    double vect2[3] = { 0.0, 1.0, 0.0 };

    for (i = 0; i < n_dim; ++i)
        body_frame[i] = u[i];

    if (n_dim == 2) {
        body_frame[2] = u[1];
        body_frame[3] = -u[0];
    } else if (n_dim == 3) {
        if (1.0 - ABS(u[0]) > 1e-2)
            cross_product(u, vect1, &(body_frame[3]), n_dim);
        else
            cross_product(u, vect2, &(body_frame[3]), n_dim);

        norm_factor = 0.0;
        for (i = 0; i < n_dim; ++i)
            norm_factor += SQR(body_frame[n_dim + i]);
        norm_factor = 1 / sqrt(norm_factor);
        for (i = 0; i < n_dim; ++i)
            body_frame[n_dim + i] *= norm_factor;

        cross_product(u, &(body_frame[3]), &(body_frame[6]), n_dim);
    }
}
