#ifndef NOGRAPH
#include "bob.h"
#include "graphics.h"
#include <png++/png.hpp>
#include <iostream>
#include <iomanip>

void grabber(int width, int height, std::string fname, int framenum) {
    /* Set up Alignment format for bitmaps */
    glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
    glPixelStorei(GL_PACK_ALIGNMENT, 1);
    glPixelStorei(GL_UNPACK_SKIP_ROWS, 0);
    glPixelStorei(GL_UNPACK_SKIP_PIXELS, 0);

    /* Define pixel array for a no extra byte. Mode 1. */
    std::vector<GLubyte> pixels(3*width*height);
    
    /* Store Full Image from the back buffer */
    glPixelStorei(GL_UNPACK_ROW_LENGTH, 0);

    /* Store image in memory */
    glReadPixels(0, 0, width, height, GL_RGB, GL_UNSIGNED_BYTE, pixels.data());

    /* Save pixels' RGB values inverse to png image buffer */
    png::image<png::rgb_pixel> image(width, height);
    for (int y = 0; y < height; y++) {
        for (int x = 0; x < width; x++) {
            GLubyte r = pixels[0 + 3 * (x + height * y)];
            GLubyte g = pixels[1 + 3 * (x + height * y)];
            GLubyte b = pixels[2 + 3 * (x + height * y)];
            image.set_pixel(x, height-y-1, png::basic_rgb_pixel<GLubyte>(r,g,b));
        }
    }
    
    /* Create png filename and write to file. */
    std::ostringstream fnameStream;
    fnameStream << fname << "_" << std::setfill('0') << std::setw(5) <<
        framenum << ".png";
    std::cout << "Writing image: " << fnameStream.str() << std::endl;
    image.write(fnameStream.str());
}

#endif

