#ifndef NOGRAPH
#ifndef _GRAPHICS_H
#define _GRAPHICS_H

#include <vector>

//#ifndef _SYSTEM_PROPERTIES
//typedef struct system_properties system_properties;
//#endif
#include "parameters.h"
#include <string>
#include "chromosome_management.h"
#include "xlink_entry.h"
#include <GL/glew.h>
#include <GLFW/glfw3.h>
#include <GL/glu.h>

class GraphicsPrimitive {
 public:
    GLuint vertex_buffer_, element_buffer_;
    GLuint vertex_shader_, fragment_shader_, program_;
    GLfloat *vertex_buffer_data_;
    GLushort *element_buffer_data_;

    struct {
        GLint half_l;
        GLint diameter;
    } uniforms_;

    struct {
        GLint position;
    } attributes_;

    int n_coords_;
    int n_triangles_;

    void MakeProgram();
    GLuint MakeBuffer(GLenum target, const void *buffer_data, GLsizei buffer_size);
    void MakeVertexBuffer();
    void MakeElementBuffer();
    void ShowInfoLog(GLuint object, PFNGLGETSHADERIVPROC glGet__iv,
                     PFNGLGETSHADERINFOLOGPROC glGet__InfoLog);
    void PrepDraw();
    void Draw(GLfloat v0, GLfloat v1, GLfloat v2);
    void Draw(GLfloat v0, GLfloat v1, GLfloat v2,
              GLfloat theta, GLfloat phi);
};

/* The <graphics_parameters> structure contains a variety of graphics parameters. */
class Graphics {
 public:
    double color_vector_[3];
    GLFWwindow *window_; // Our actual window
    int windx_; // window x dimension in pixels
    int windy_; // window y dimension in pixels
    int width_fb_; // framebuffer x dimension in pixels
    int height_fb_; // framebuffer y dimension in pixels

    double mousex_; // cursor x position
    double mousey_; // cursor y position
    bool mouse_is_pressed_; // tells us if mouse button is being pressed
    bool key_is_pressed_; // tells us if key is being held down
    //bool tomogram_view_ = false; // switch to and from tomorgraphic view
    int key_being_held_; // tells us which key is being held down;
    int tomogram_view_ = 0; // tells us what kind of view to take
                            // 0 = fixed
                            // 1 = planar view of spindle/spbs
                            // 2 = chromosome0
                            // 3 = chromosome1
                            // 4 = chromosome2
    
    int n_dim_; // number of physical dimensions we're drawing

    GraphicsPrimitive discorectangle_; // 2d spherocylinder
    GraphicsPrimitive spherocylinder_; // actual spherocylinder
    GraphicsPrimitive kinetochoremesh_; // kinetochore mesh

    GLfloat xAngle_, yAngle_, zAngle_; // system rotation
    GLfloat xyzScale_; // zoom
    GLfloat xTrans_, yTrans_, zTrans_; // translation of system
    GLfloat zNear_, zFar_, cNear_, cFar_; // camera positions and clipping planes
    GLfloat cxAngle_, cyAngle_; // clipping plane angles
    GLfloat sphere_color_[3], box_color_[3], background_color_[3];
    GLfloat alpha_; // transparency (1 opaque, 0 invisible)

    static const int n_rgb_ = 384;
    static const int shift_ = 84;
    GLfloat colormap_[n_rgb_*4];

    int color_switch_; // which coloring algorithm to use
    int keep_going_; // Allow to draw same configuration in loop
    std::string boundary_type_; // boundary type to draw. currently supports
                                // "cube" and "sphere"

 public:
    void Init( system_parameters * params, int n_dim, double **h, int n_anchors, triangle_mesh *example_kinetochore = NULL); // Init. Must always be called.
    // n_dim: number of dimensions (2 or 3 currently supported)
    // h: n_dim x n_dim unit cell matrix 
    
    void DrawLoop(int n_bonds, double **h,
                  double **r, double **u, double *length,
                  int n_sites, double **r_site,
                  double sphere_diameter); // Same as draw, but loop indefinitely
    void DrawLoop(int n_bonds, double **h,
                  double **r, double **u, double *length);
    void DrawLoop(int n_bonds, double **h,
                  double **r, double **u, double *length,
                  int n_types, xlink_list **xlinks);
    void DrawLoop(int n_bonds, double **h,
                  double **r, double **u, double *length,
                  int n_types, xlink_list *xlinks_0, xlink_list **xlinks_2);
    void DrawLoop(int n_bonds, double **h,
                  double **r, double **u, double *length,
                  int n_types, xlink_list *xlinks_0, xlink_list **xlinks_1,
                  xlink_list **xlinks_2);
    void DrawLoop(int n_bonds,
                  double **h,
                  double **r,
                  double **u,
                  double *length,
                  int n_types,
                  xlink_list *xlinks_0,
                  xlink_list **xlinks_1,
                  xlink_list **xlinks_2,
                  int n_anchors,
                  int anchor_type,
                  float **color_anchor,
                  double **r_anchor,
                  double **u_anchor,
                  double **v_anchor,
                  double **w_anchor,
                  double *adiam,
                  int n_chromosomes,
                  ChromosomeManagement *chromosomes);
    void Draw(int n_bonds, double **h,
              double **r, double **u, double *length); // Draw current simulation frame
    void Draw(int n_bonds, double **h,
              double **r, double **u, double *length,
              int n_types, xlink_list **xlinks); // Draw current simulation frame
    void Draw(int n_bonds, double **h,
              double **r, double **u, double *length,
              int n_types, xlink_list *xlinks_0, xlink_list **xlinks_2);
    void Draw(int n_bonds, double **h,
              double **r, double **u, double *length,
              int n_types, xlink_list *xlinks_0, xlink_list **xlinks_1, xlink_list **xlinks_2);
    void Draw(int n_bonds,
              double **h,
              double **r,
              double **u,
              double *length,
              int n_types,
              xlink_list *xlinks_0,
              xlink_list **xlinks_1,
              xlink_list **xlinks_2,
              int n_anchors,
              int anchor_type,
              float **anchor_color,
              double **r_anchor,
              double **u_anchor,
              double **v_anchor,
              double **w_anchor,
              double *adiam,
              int n_chromosomes,
              ChromosomeManagement *chromosomes);
    // n_bonds: number of spherocylinders
    // h: unit cell matrix
    // r: center of mass positions of spherocylinders
    // u: orientation vectors for spherocylinders
    // length: length of spherocylinders
    // n_types: number of crosslink types
    // xlinks: 2d array of crosslinks
    void Draw(int n_bonds, double **h,
              double **r, double **u, double *length,
              int n_sites, double **r_site,
              double sphere_diameter); // Draw current simulation frame with spheres too!
    // n_bonds: number of spherocylinders
    // h: unit cell matrix
    // r: center of mass positions of spherocylinders
    // u: orientation vectors for spherocylinders
    // length: length of spherocylinders
    // n_sites: actual number of sites (2 * n_bonds + n_spheres) FIXME
    // r_site: site positions matrix
    // sphere_diameter: diameter of spheres! //fixme, could be carried along 
    
    void SetBoundaryType(std::string boundary_type); //Set the boundary type to draw
    void ResizeWindow(int width, int height);
    
 private:
    system_parameters * params_;
    system_properties * properties_;
    GLUquadricObj *qobj_;
    int n_anchors_;
    bool first_call_quaternion_;
    std::vector<std::vector<double>> utilde_;
    double ntomo_[3];
    double rhatspb_[3];
    double rchromosome_[3];
    double quaternion_old_[4];
    void InitColormap(); 
    void InitDiscoRectangle();
    void InitSpheroCylinder();
    void InitKinetochoreMesh(triangle_mesh *example_mesh);
    void InitWindow(int n_dim, double **h);
    void Init2dWindow(double **h);
    void Init3dWindow(double **h);
    void KeyInteraction();
    void DrawBox(double **h); // Wrapper for rectangular boundaries
    void DrawSquare(double **h); //boundary square
    void DrawCube(double **h); // boundary cube
    void DrawWireSphere(double r, int lats, int longs); // Slow, not for mass drawing, just for boundary
    void DrawBoundary(double **h); 
    void DrawSpheros(int n_spheros, double **r, double **u, double *length, ChromosomeManagement *chromosomes = NULL); // draw spherocylinders (3d)
    void DrawDiscorectangles(int n_spheros, double **r, double **u, double *length); // draw solid discorectangles (2d spherocylinders)
    void DrawSpheres(int n_spheres, double **r, double sphere_diameter); // Draw solid spheres
    void DrawAnchorsOld(int n_anchors, double **r_anchor, double *anchor_diameter, double **h, float **anchor_color);
    void DrawAnchorsNew(int n_anchors, double **r_anchor, double **u_anchor, double **v_anchor, double **w_anchor, double *anchor_diameter, double **h, float **anchor_color);
    void DrawAnchors(int n_anchors, double **r_anchor, double *anchor_diameter, double **h);
    void UpdateWindow(); // update window parameters in case of resize
    void Draw2d(int n_bonds, double **h, double **r, double **u, double *length);
    void Draw2d(int n_bonds, double **h, double **r, double **u, double *length,
                int n_types, xlink_list **xlinks);
    void Draw3d(int n_bonds, double **h, double **r, double **u, double *length);
    void Draw3d(int n_bonds, double **h, double **r, double **u, double *length,
                int n_sites, double **r_site, double sphere_diameter);
    void Draw3d(int n_bonds, double **h,
                double **r, double **u, double *length,
                int n_types, xlink_list **xlinks);
    void Draw3d(int n_bonds, double **h,
                double **r, double **u, double *length,
                int n_types, xlink_list *xlinks_0, xlink_list **xlinks_2);
    void Draw3d(int n_bonds, double **h,
                double **r, double **u, double *length,
                int n_types, xlink_list *xlinks_0, xlink_list **xlinks_1,
                xlink_list **xlinks_2);
    void Draw3d(int n_bonds,
                double **h,
                double **r_bond,
                double **u_bond,
                double *rlength,
                int n_types,
                xlink_list *xlinks0,
                xlink_list **xlinks1,
                xlink_list **xlinks2,
                int n_anchors,
                int anchor_type,
                float **anchor_color,
                double **r_anchor,
                double **u_anchor,
                double **v_anchor,
                double **w_anchor,
                double *adiam,
                int n_chromosomes,
                ChromosomeManagement *chromosomes);

    void DrawCrosslinks(int n_bonds, double **r, double **u, double *length,
                        int n_types, xlink_list **xlinks);
    void DrawCrosslinks(int n_bonds, double **r, double **u, double *length,
                        int n_types, xlink_list *xlinks_0, xlink_list **xlinks_1,
                        xlink_list **xlinks_2);
    void DrawCrosslinks(int n_bonds, double **r, double **u, double *length,
                        int n_types, xlink_list *xlinks_0, xlink_list **xlinks_2);

    void DrawKinetochores(int n_bonds,
                          double **r,
                          double **u,
                          double *length,
                          int n_chromosomes,
                          ChromosomeManagement *chromosomes);
    void DrawKinetochores_old(int n_bonds,
                          double **r,
                          double **u,
                          double *length,
                          int n_chromosomes,
                          ChromosomeManagement *chromosomes);
    void DrawKinetochoreMesh(Kinetochore *kc);
    void DrawAxes();
    void GenerateTomogramViewUtildeAvg(int nbonds,
                                       double **ubond,
                                       int nanchors);
    void GenerateTomogramViewSPBs(double **ranchor,
                                  int nanchors);
    void GenerateChromosomeView(int n_chromosomes,
                                ChromosomeManagement *chromosomes);
};

#endif
#endif
