#include "helpers.h"
#include "probabilities.h"

#include <gsl/gsl_integration.h>
#include <math.h>
#include <iostream>

double my_erfinv(double x) {
    // See: A handy approximation for the error function and its inverse
    // (Winitzki 2008) (google it). This isn't a great approximation, but it
    // will do the trick. It's not programmed for efficiency since it should
    // only be called n_types_ times during an entire program execution. If you
    // need better precision/performance, boost apparently has a version
    const double a = 0.147;
    double t1 = -2/M_PI/a;
    double t2 = -log(1-x*x)/2;
    double t3 = 2/M_PI/a + log(1-x*x)/2;
    double t4 = -log(1-x*x)/a;

    return sqrt(t1 + t2 + sqrt(t3*t3 + t4));
}

//FIXME Needs commenting, what are all the parameters
double prob_1_2(std::vector<double> &x, void *params) {
    gsl_integration_workspace *w
        = gsl_integration_workspace_alloc (1000);

    xlink_params *inparams = (xlink_params*) params;
    xlink_params gslparams;
    gslparams.alpha = inparams->alpha;
    gslparams.r0 = inparams->r0;
    gslparams.y0 = x[1];

    gsl_function F;
    F.function = &integrand_1_2;
    F.params = &gslparams;

    double result, error;
    if (x[0] > 0)
        gsl_integration_qags (&F, 0, x[0], 0, 1e-7, 1000,
                              w, &result, &error);
    else
        result = 0;

    gsl_integration_workspace_free (w);

    return result;
}

double prob_1_2_fdep(std::vector<double> &x, void *params) {
    gsl_integration_workspace *w
        = gsl_integration_workspace_alloc(1000);

    xlink_params *inparams = (xlink_params*) params;
    xlink_params gslparams;
    gslparams.alpha = inparams->alpha;
    gslparams.r0 = inparams->r0;
    gslparams.xc = inparams->xc;
    gslparams.y0 = x[1];

    gsl_function F;
    F.function = &integrand_1_2_fdep;
    F.params = &gslparams;

    double result, error;
    if (x[0] > 0)
        gsl_integration_qags (&F, 0, x[0], 0, 1e-7, 1000,
                              w, &result, &error);
    else
        result = 0;

    gsl_integration_workspace_free (w);

    return result;
}

