#ifndef _HELPERS_H_
#define _HELPERS_H_

#include <algorithm>
#include <cmath>
#include <map>
#include <string>
#include <vector>

double my_erfinv(double x);
double prob_1_2(std::vector<double> &x, void *params);
double prob_1_2_fdep(std::vector<double> &x, void *params);

// Reflection factory!
namespace rfh {
    template <class T> void* constructor() { return (void*)new T(); }

    struct factory {
        typedef void*(*constructor_t)();
        typedef std::map<std::string, constructor_t> map_type;
        map_type m_classes;

        template<class T>
        void register_class(std::string const& n) {
            m_classes.insert(std::make_pair(n, &constructor<T>));
        }

        void *construct(std::string const& n) {
            map_type::iterator i = m_classes.find(n);
            if (i == m_classes.end()) return 0;
            return i->second();
        }
    };
}

// Safe arc cosine from -1 to 1
inline double safe_acos(double x) {
    if (x < -1.0) x = -1.0;
    else if (x > 1.0) x = 1.0;
    return acos(x);
}

// inline logically equals
inline bool logically_equal(double a, double b, double error_factor = 1.0) {
    return a == b ||
        std::abs(a-b)<std::abs(std::min(a,b))*std::numeric_limits<double>::epsilon()*error_factor;
}

// inline almost equals
inline bool almost_equal(double x, double y, double eps) {
    return (x >= y - eps && x <= y + eps);
}

#endif
