/* Initialize and allocate memory for variables in bond structure.
 
 Input: pointer to parameters structure (parameters)
 pointer to properties structure (properties)
 
 Output: memory for a variety of arrays is allocated, 
 and a number of variables are initialized */

#include "bob.h"

void init_anchor_structure(system_parameters *parameters,
                           system_properties *properties) {

    int n_anchors = properties->anchors.n_anchors;
    int n_dim = parameters->n_dim;
    if (n_anchors != 0) {
        properties->anchors.anchor_list = new al_list[n_anchors];
        properties->anchors.gamma_tra = (double*) allocate_1d_array(n_anchors, sizeof(double));
        properties->anchors.gamma_rot = (double*) allocate_1d_array(n_anchors, sizeof(double));
        properties->anchors.k = (double*) allocate_1d_array(n_anchors, sizeof(double));
        properties->anchors.r0 = (double*) allocate_1d_array(n_anchors, sizeof(double));
        properties->anchors.kr = (double*) allocate_1d_array(n_anchors, sizeof(double));
        properties->anchors.diameter = (double*) allocate_1d_array(n_anchors, sizeof(double));
        properties->anchors.attach_diameter = (double*) allocate_1d_array(n_anchors, sizeof(double));
        properties->anchors.r_anchor = (double**) allocate_2d_array(n_anchors, n_dim, sizeof(double));
        properties->anchors.u_anchor = (double**) allocate_2d_array(n_anchors, n_dim, sizeof(double));
        properties->anchors.v_anchor = (double**) allocate_2d_array(n_anchors, n_dim, sizeof(double));
        properties->anchors.w_anchor = (double**) allocate_2d_array(n_anchors, n_dim, sizeof(double));
        properties->anchors.f_anchor = (double**) allocate_2d_array(n_anchors, n_dim, sizeof(double));
        properties->anchors.tau_local = (double**) allocate_2d_array(n_anchors, n_dim, sizeof(double));
        properties->anchors.color_ = (float**) allocate_2d_array(n_anchors, 4, sizeof(float));
    }
    else {
        properties->anchors.anchor_list = NULL;
    }

    return;
}
