/* Initialize and allocate memory for variables in bond structure.
 
 Input: pointer to parameters structure (parameters)
 pointer to properties structure (properties)
 
 Output: memory for a variety of arrays is allocated, 
 and a number of variables are initialized */

#include "bob.h"

void init_bond_structure_sphero(system_parameters *parameters,
                                system_properties *properties) {


    /* Allocate memory for arrays in bond structure. */
    int n_bonds = properties->bonds.n_bonds;
    int n_dim = parameters->n_dim;
    properties->bonds.bond_site_1 = (int *) allocate_1d_array(n_bonds, sizeof(int));
    properties->bonds.bond_site_2 = (int *) allocate_1d_array(n_bonds, sizeof(int));
    properties->bonds.r_bond =
        (double **) allocate_2d_array(n_bonds, n_dim, sizeof(double));
    properties->bonds.s_bond =
        (double **) allocate_2d_array(n_bonds, n_dim, sizeof(double));
    properties->bonds.v_bond =
        (double **) allocate_2d_array(n_bonds, n_dim, sizeof(double));
    properties->bonds.u_bond =
        (double **) allocate_2d_array(n_bonds, n_dim, sizeof(double));
    properties->bonds.f_bond =
        (double **) allocate_2d_array(n_bonds, n_dim, sizeof(double));
    properties->bonds.t_bond =
        (double **) allocate_2d_array(n_bonds, 3, sizeof(double));
    properties->bonds.fbondtip_ne =
        (double **) allocate_2d_array(n_bonds, n_dim, sizeof(double));
    
    properties->bonds.length = (double *) allocate_1d_array(n_bonds, sizeof(double));
    properties->bonds.length2 = (double *) allocate_1d_array(n_bonds, sizeof(double));

    properties->bonds.rng_local = (rng_properties*)
        allocate_1d_array(n_bonds, sizeof(rng_properties));
    
    /* Initialize arrays of bond site labels. */
    int i_site = 0;
    for (int i_bond = 0; i_bond < n_bonds; ++i_bond) {
        properties->bonds.bond_site_1[i_bond] = i_site;
        ++i_site;
        properties->bonds.bond_site_2[i_bond] = i_site;
        ++i_site;
    }

    /* Compute bond vectors and bond positions. */
    update_bond_vectors(parameters->n_dim, parameters->n_periodic,
                        properties->bonds.n_bonds, properties->unit_cell.h,
                        properties->sites.s, properties->sites.r,
                        properties->bonds.bond_site_1, properties->bonds.bond_site_2,
                        properties->bonds.v_bond,
                        properties->bonds.u_bond,
                        properties->bonds.length,
                        properties->bonds.length2);
    update_bond_positions(parameters->n_dim, parameters->n_periodic,
                          properties->bonds.n_bonds, properties->unit_cell.h,
                          properties->unit_cell.h_inv,
                          properties->sites.r, properties->bonds.bond_site_1,
                          properties->bonds.v_bond, properties->bonds.r_bond,
                          properties->bonds.s_bond);

    return;
}
