// Initialize the free diffusion similar to the way that spindle_bd_mp does it

#include "bob.h"

#include <iostream>

void init_diffusion_analysis_free(system_parameters *parameters,
                                  system_properties *properties,
                                  system_potential *potential) {
    // Set up pointers to the header read and write functions
    properties->read_header_func = read_header_spb_dynamics;
    properties->write_header_func = write_header_spb_dynamics;

    // Set up master RNG
    gsl_rng_env_setup();
    properties->rng.T = gsl_rng_default;
    properties->rng.r = gsl_rng_alloc(properties->rng.T);
    gsl_rng_set(properties->rng.r, parameters->seed);

    // Run the configurator
    configurator_generic(parameters, properties, parameters->config_file);

    // Initialize unit cell structure
    init_unit_cell_structure(parameters, properties);

    // Initialize diffusion information
    init_diffusion_sphero(parameters, properties);

    // initialize crosslinks because
    properties->crosslinks.Init(parameters,
                                properties,
                                parameters->crosslink_file,
                                NULL);

    // Turn on chromosomes for diffusion tests
    properties->chromosomes.Init(parameters,
                                 properties,
                                 parameters->chromosome_config,
                                 parameters->chromosome_output);

    // Allocate memory for arrays in thermodynamics structure.
    properties->thermo.virial = (double **)
        allocate_2d_array(parameters->n_dim, parameters->n_dim, sizeof(double));
    properties->thermo.stress = (double **)
        allocate_2d_array(parameters->n_dim, parameters->n_dim, sizeof(double));
    properties->thermo.press_tensor = (double **)
        allocate_2d_array(parameters->n_dim, parameters->n_dim, sizeof(double));

    // Update the trajectory information
    update_bond_site_positions_mp(parameters->n_dim, parameters->n_periodic,
                                  properties->bonds.n_bonds, properties->sites.n_sites,
                                  properties->unit_cell.h, properties->unit_cell.h_inv,
                                  properties->bonds.bond_site_1, properties->bonds.bond_site_2,
                                  properties->bonds.r_bond, properties->bonds.u_bond,
                                  properties->bonds.length, 
                                  properties->sites.r, properties->sites.s);

    // Set the multithreaded random number generators
    for (int ibond = 0; ibond < properties->bonds.n_bonds; ++ibond) {
        auto mseed = gsl_rng_get(properties->rng.r);
        properties->bonds.rng_local[ibond].T = gsl_rng_default;
        properties->bonds.rng_local[ibond].r = gsl_rng_alloc(properties->bonds.rng_local[ibond].T);
        gsl_rng_set(properties->bonds.rng_local[ibond].r, mseed);
    }

    // NO POTENTIALS
    potential->n_comp = 0;
    potential->calc_matrix = (int*) allocate_1d_array(properties->bonds.n_bonds, sizeof(int));

    properties->time = 0.0;

    /* Initialize control structure. */
    properties->control.bond_vector_flag = 1;
    properties->control.bond_position_flag = 1;
    properties->control.cell_list_flag = 1;
    properties->control.neighbor_list_flag = 1;

}
