#include "bob.h"

void init_diffusion_sphero(system_parameters *parameters, system_properties *properties) {
    //int i_bond, n_bonds, min_bond, diffusion_override_flag;
    //double *gamma_perp, *gamma_par, *gamma_rot, *length;
    //double viscosity, inv_l, inv_l2, log_l, gamma_0, p, temp, max_delta, min_length,
    //    diffusion_scale;


    int n_bonds = properties->bonds.n_bonds;
    //length = properties->bonds.length;
    //viscosity = 1.0/3.0/M_PI;
    //temp = parameters->temp;
    //diffusion_override_flag = parameters->diffusion_override_flag;
    //diffusion_scale = parameters->diffusion_scale;

    //gamma_perp = properties->bonds.gamma_perp = (double *) allocate_1d_array(n_bonds, sizeof(double));
    //gamma_par = properties->bonds.gamma_par = (double *) allocate_1d_array(n_bonds, sizeof(double));
    //gamma_rot = properties->bonds.gamma_rot = (double *) allocate_1d_array(n_bonds, sizeof(double));
    properties->bonds.gamma_perp = (double *) allocate_1d_array(n_bonds, sizeof(double));
    properties->bonds.gamma_par = (double *) allocate_1d_array(n_bonds, sizeof(double));
    properties->bonds.gamma_rot = (double *) allocate_1d_array(n_bonds, sizeof(double));

    properties->bonds.diff_par = (double *) allocate_1d_array(n_bonds, sizeof(double));
    properties->bonds.diff_perp = (double *) allocate_1d_array(n_bonds, sizeof(double));
    properties->bonds.diff_rot = (double *) allocate_1d_array(n_bonds, sizeof(double));

    configure_diffusion_sphero(parameters, properties);
    
    //if (parameters->dynamic_instability_flag) {
    //    min_length = MIN(parameters->min_length, length[0]);
    //    min_bond = -1;
    //}
    //else {
    //    min_length = length[0];
    //    min_bond = 0;
    //}
    //for (i_bond = 0; i_bond < n_bonds; ++i_bond) {
    //    p = (length[i_bond] + 1.0) / 1.0;
    //    inv_l = 1.0 / p;
    //    inv_l2 = SQR(inv_l);
    //    log_l = log(p);
    //    gamma_0 = viscosity * (length[i_bond] + 1.0) * M_PI;
    //    
    //    gamma_perp[i_bond] = 4.0 * gamma_0 / (log_l + 0.839 + 0.185 * inv_l + 0.233 * inv_l2);
    //    gamma_par[i_bond] = 2.0 * gamma_0 / (log_l - 0.207 + 0.98 * inv_l - 0.133 * inv_l2);
    //    gamma_rot[i_bond] =
    //        SQR(length[i_bond] + 1.0) * gamma_0 / 3.0 / (log_l - 0.662 + 0.917 * inv_l - 0.050 * inv_l2);

    //    if (diffusion_override_flag == 1) {
    //        gamma_rot[i_bond] /= diffusion_scale;
    //        gamma_perp[i_bond] /= diffusion_scale;
    //        gamma_par[i_bond] /= diffusion_scale;
    //    }

    //    properties->bonds.diff_perp[i_bond] = temp / gamma_perp[i_bond];
    //    properties->bonds.diff_par[i_bond] = temp / gamma_par[i_bond];
    //    properties->bonds.diff_rot[i_bond] = temp / gamma_rot[i_bond];

    //    if (length[i_bond] < min_length) {
    //        min_length = length[i_bond];
    //        min_bond = i_bond;
    //    }
    //}

    //double factor = 0.0004;
    //if (min_bond == -1) {
    //    p = (min_length + 1.0) / 1.0;
    //    inv_l = 1.0 / p;
    //    inv_l2 = SQR(inv_l);
    //    log_l = log(p);
    //    gamma_0 = viscosity * (p) * M_PI;
    //    
    //    double gamma_p = 2.0 * gamma_0 / (log_l - 0.207 + 0.98 * inv_l - 0.133 * inv_l2);
    //    double gamma_r = SQR(p) * gamma_0 / 3.0 / (log_l - 0.662 + 0.917 * inv_l - 0.050 * inv_l2);

    //    max_delta = factor * MIN(2 * gamma_r / SQR(min_length), 0.5 * gamma_p);
    //}
    //else {
    //    max_delta = factor * MIN(2 / properties->bonds.diff_rot[min_bond] / SQR(min_length),
    //                         0.5 / properties->bonds.diff_par[min_bond]);
    //}

    //if (parameters->delta > max_delta) {
    //    printf("WARNING: timestep larger than maximum recommended value for minimum length rod in the system. ");
    //    printf("Changing from input timestep of delta = %g to maximum recommended value of delta = %g\n", parameters->delta, max_delta);
    //    parameters->delta = max_delta;
    //}

    //fprintf(stdout, "   diff_par[0] = %g\n", properties->bonds.diff_par[0]);
    //fprintf(stdout, "   diff_perp[0] = %g\n", properties->bonds.diff_perp[0]);
    //fprintf(stdout, "   diff_rot[0] = %g\n", properties->bonds.diff_rot[0]);
    //fprintf(stdout, "\n");
}

// Reinitialize the bonds from when we read them in....
void configure_diffusion_sphero(system_parameters *parameters, system_properties *properties) {
    int nbonds = properties->bonds.n_bonds;
    int i_bond, n_bonds, min_bond, diffusion_override_flag;
    double *gamma_perp, *gamma_par, *gamma_rot, *length;
    double viscosity, inv_l, inv_l2, log_l, gamma_0, p, temp, max_delta, min_length,
        diffusion_scale;

    n_bonds = properties->bonds.n_bonds;
    length = properties->bonds.length;
    viscosity = 1.0/3.0/M_PI;
    temp = parameters->temp;
    diffusion_override_flag = parameters->diffusion_override_flag;
    diffusion_scale = parameters->diffusion_scale;

    gamma_perp  = properties->bonds.gamma_perp;
    gamma_par   = properties->bonds.gamma_par;
    gamma_rot   = properties->bonds.gamma_rot;

    if (parameters->dynamic_instability_flag) {
        min_length = MIN(parameters->min_length, length[0]);
        min_bond = -1;
    }
    else {
        min_length = length[0];
        min_bond = 0;
    }
    for (i_bond = 0; i_bond < n_bonds; ++i_bond) {
        p = (length[i_bond] + 1.0) / 1.0;
        inv_l = 1.0 / p;
        inv_l2 = SQR(inv_l);
        log_l = log(p);
        gamma_0 = viscosity * (length[i_bond] + 1.0) * M_PI;
        
        gamma_perp[i_bond] = 4.0 * gamma_0 / (log_l + 0.839 + 0.185 * inv_l + 0.233 * inv_l2);
        gamma_par[i_bond] = 2.0 * gamma_0 / (log_l - 0.207 + 0.98 * inv_l - 0.133 * inv_l2);
        gamma_rot[i_bond] =
            SQR(length[i_bond] + 1.0) * gamma_0 / 3.0 / (log_l - 0.662 + 0.917 * inv_l - 0.050 * inv_l2);

        if (diffusion_override_flag == 1) {
            gamma_rot[i_bond] /= diffusion_scale;
            gamma_perp[i_bond] /= diffusion_scale;
            gamma_par[i_bond] /= diffusion_scale;
        }

        properties->bonds.diff_perp[i_bond] = temp / gamma_perp[i_bond];
        properties->bonds.diff_par[i_bond] = temp / gamma_par[i_bond];
        properties->bonds.diff_rot[i_bond] = temp / gamma_rot[i_bond];

        if (length[i_bond] < min_length) {
            min_length = length[i_bond];
            min_bond = i_bond;
        }
    }

    double factor = 0.0004;
    if (min_bond == -1) {
        p = (min_length + 1.0) / 1.0;
        inv_l = 1.0 / p;
        inv_l2 = SQR(inv_l);
        log_l = log(p);
        gamma_0 = viscosity * (p) * M_PI;
        
        double gamma_p = 2.0 * gamma_0 / (log_l - 0.207 + 0.98 * inv_l - 0.133 * inv_l2);
        double gamma_r = SQR(p) * gamma_0 / 3.0 / (log_l - 0.662 + 0.917 * inv_l - 0.050 * inv_l2);

        max_delta = factor * MIN(2 * gamma_r / SQR(min_length), 0.5 * gamma_p);
    }
    else {
        max_delta = factor * MIN(2 / properties->bonds.diff_rot[min_bond] / SQR(min_length),
                             0.5 / properties->bonds.diff_par[min_bond]);
    }

    if (parameters->delta > max_delta) {
        printf("WARNING: timestep larger than maximum recommended value for minimum length rod in the system. ");
        printf("Changing from input timestep of delta = %g to maximum recommended value of delta = %g\n", parameters->delta, max_delta);
        parameters->delta = max_delta;
    }

    fprintf(stdout, "   diff_par[0] = %g\n", properties->bonds.diff_par[0]);
    fprintf(stdout, "   diff_perp[0] = %g\n", properties->bonds.diff_perp[0]);
    fprintf(stdout, "   diff_rot[0] = %g\n", properties->bonds.diff_rot[0]);
    fprintf(stdout, "\n");
}
