#include "bob.h"

void init_dynamic_instability(system_parameters *parameters, system_properties *properties) {
    int n_bonds, i, n_dim, n_periodic;
    double min_lin_dim;
    FILE *f_poly;
    int *stab_state;
    poly_state_enum *poly_state;
    char *poly_config;

    n_dim = parameters->n_dim;
    n_periodic = parameters->n_periodic;
    n_bonds = properties->bonds.n_bonds;
    poly_config = parameters->poly_config;

    poly_state = properties->bonds.poly_state = 
        (poly_state_enum*) allocate_1d_array(n_bonds, sizeof(poly_state_enum));
    stab_state = properties->bonds.stab_state = 
        (int*) allocate_1d_array(n_bonds, sizeof(int));

    if (poly_config != NULL) {
        f_poly = gfopen(poly_config, "r");
        fread(poly_state, sizeof(unsigned char), n_bonds, f_poly);
    }
    else if (parameters->f_pause_to_grow > 0.0 && parameters->f_grow_to_pause == 0.0
             && parameters->f_shrink_to_pause == 0.0) {
        fprintf(stdout, "Warning: no polymerization state file provided and only f_pause_to_grow set, " \
                "starting all bonds in pause state\n");
        for (i = 0; i < n_bonds; ++i)
            poly_state[i] = PAUSE;
    }
    else {
        fprintf(stdout, "Warning: no polymerization state file provided, " \
                "starting all bonds in random grow or shrink state\n");
        for (i = 0; i < n_bonds; ++i)
            poly_state[i] = ((gsl_rng_uniform(properties->rng.r) ) < 0.5) ? GROW : SHRINK;
    }

    for (i = 0; i < n_bonds; ++i)
        stab_state[i] = -1;

    min_lin_dim = properties->unit_cell.a_perp[0];
    for (i = 1; i < n_dim; ++i)
        min_lin_dim = MIN(properties->unit_cell.a_perp[i], min_lin_dim);


    if (parameters->max_length <= 0.0) {
        if (n_periodic == n_dim) {
            parameters->max_length = 0.5 * min_lin_dim;
            printf("Warning: max_length undefined. setting to half minimum linear dimension\n");
        }
        else {
            parameters->max_length = min_lin_dim;
            printf("Warning: max_length undefined. setting to minimum linear dimension\n");
        }
    }
    else if (parameters->max_length > 0.5 * min_lin_dim && parameters->n_periodic == n_dim) {
        parameters->max_length = 0.5 * min_lin_dim;
        printf("Warning: max_length greater than half minimum linear dimension, setting to half minimum linear dimension\n");
    }
    fprintf(stdout,"maximum mt length %.2lf\n", parameters->max_length);

    if (parameters->f_grow_to_shrink <= 1.0e-9 &&
            !parameters->force_poly_flag) {
        parameters->f_grow_to_shrink = 1.0e-9;
        printf("Warning: Catastrophe frequency less than the minimum, setting to 10^-9.\n");
    }

}
