/* Initialize and allocate memory for variables in site structure.
 
 Input: pointer to parameters structure (parameters)
 pointer to properties structure (properties)
 
 Output: memory for a variety of arrays is allocated, 
 and a number of variables are initialized */

#include "bob.h"

void init_site_structure_sphero(system_parameters * parameters,
                                system_properties * properties)
{
    int n_dim, n_periodic, n_sites;
    double **h, **h_inv, **r, **s;

    /* Set up shortcuts to data structures. */
    n_dim = parameters->n_dim;
    n_periodic = parameters->n_periodic;
    h = properties->unit_cell.h;
    h_inv = properties->unit_cell.h_inv;
    n_sites = properties->sites.n_sites;
    r = properties->sites.r;

    /* Allocate memory for arrays in site structure. */
    s = properties->sites.s = (double **) allocate_2d_array(n_sites, n_dim, sizeof(double));
    properties->sites.f = (double **) allocate_2d_array(n_sites, n_dim, sizeof(double));
    properties->sites.dr_tot = (double **) allocate_2d_array(n_sites, n_dim, sizeof(double));

    /* Compute scaled site coordinates and apply periodic boundary conditions. */
    if (n_periodic > 0)
        periodic_boundary_conditions(n_periodic, n_sites, h, h_inv, r, s);

    return;
}
