/* Initialize unit cell structure.

   Input: pointer to parameters structure (parameters)
          pointer to properties structure (properties)

   Output: memory for a variety of arrays is allocated, 
           and a number of variables are initialized */

#include "bob.h"

void init_unit_cell_structure(system_parameters * parameters, system_properties * properties)
{
    int n_dim;
    double **h, **h_inv, **a, **b, *a_perp;

    /* Set up shortcuts to data structures. */
    n_dim = parameters->n_dim;
    h = properties->unit_cell.h;

    /* Allocate memory for arrays in unit_cell structure. */
    h_inv = properties->unit_cell.h_inv =
        (double **) allocate_2d_array(n_dim, n_dim, sizeof(double));
    a = properties->unit_cell.a = (double **) allocate_2d_array(n_dim, n_dim, sizeof(double));
    b = properties->unit_cell.b = (double **) allocate_2d_array(n_dim, n_dim, sizeof(double));
    a_perp = properties->unit_cell.a_perp = (double *) allocate_1d_array(n_dim, sizeof(double));

    /* Compute inverse unit cell matrix, unit cell volume, and related quantities. */
    unit_cell_dimensions(n_dim, h, h_inv, a, b, a_perp, &(properties->unit_cell.volume));

    return;
}
