#ifndef _INTEGRATION_TEST_XLINKS_H_
#define _INTEGRATION_TEST_XLINKS_H_

#include "test_module_base.h"

struct binding_data {
  std::vector<int> N_bound;
  double N_exp;
  double N_avg;
  double N_err;
  double result;
  //void CalcStats(){
  //  for(auto d : N_bound)
  //}
  void CalcStats();
  void ZeroData(int nsteps){
    N_bound.resize(nsteps);
    std::fill(N_bound.begin(), N_bound.end(), 0);
    N_exp = N_avg = N_err = 0;
  };
};

class IntegrationTestXlinks : public TestModuleBase {
  public:
    IntegrationTestXlinks() {}
    virtual ~IntegrationTestXlinks() {}

    virtual void RunTests();
    virtual void SetTests();

    // Specialized init functionality
    void InitSystem(system_parameters *parameters,
                    system_properties *properties);
    void InitXlinkParams(system_parameters *parameters, 
                         system_properties *properties);
    void InitXlinkParams(system_parameters *parameters, 
                         system_properties *properties,
                         YAML::Node param_node);
    YAML::Node GetXlinkParamNode(std::string x_file, YAML::Node mod_node);
    void FinishInitSystem(system_parameters *parameters,
                          system_properties *properties);
    void EquilibrateXlinks(system_parameters *parameters,
                           system_properties *properties);
    void SetXlinksToSinglyBound(system_parameters *parameters,
                                system_properties *properties,
                                double r0);
    void SetXlinksToDoublyBound(system_parameters *parameters,
                                system_properties *properties,
                                double r0, double r1);
    bool CheckSelectedAnswersLookup(LookupTable *lut,
                                    std::map<double, std::map<double, double>> *sa);

    // Tests
    bool Generate2DXlinkDistribution();
    bool BindingRatioStats();
    bool CrosslinkLookupTables();

    // Test helping functions
    void SingleBindingTest(system_parameters *parameters, system_properties *properties,
                           binding_data* data); 
    void DoubleBindingTest(system_parameters *parameters, system_properties *properties,
                           binding_data* data); 

    // Unit Tests
    bool PolarAffinityUnitTest();

    // bookeeping and stuffs
    double **f_comp_;
    double **t_comp_;
    double **virial_comp_;
    int *calc_matrix_;

    // Printing functions
    void PrintMTs(system_parameters *parameters,
                  system_properties *properties);
};
#endif
