/* This routine simply calculates the inverse of a symmetric 2D
   matrix directly. Didn't calculate difference in time spent in function
   but speedup of program for small system (200 rods) was 50%. */
void invert_sym_2d_matrix(double *a, double *b) {
    double inv_det;
    inv_det = a[0]*a[3] - a[1]*a[1];
    inv_det = 1.0 / inv_det;
    b[0] = a[3] * inv_det;
    b[3] = a[0] * inv_det;
    b[1] = b[2] = -a[1] * inv_det;

    return;
}

/* This routine simply calculates the inverse of a symmetric 3D
   matrix directly (~15x faster than generic LU decomposition
   scheme matrix_inversion) */
void invert_sym_3d_matrix(double *a, double *b) {
    double inv_det;
    inv_det = a[0] * (a[4]*a[8] - a[5]*a[7])
        - a[1] * (a[3]*a[8] - a[5]*a[6])
        + a[2] * (a[3]*a[7] - a[4]*a[6]);
    inv_det = 1.0/inv_det;
    b[0] = inv_det * (a[4]*a[8] - a[5]*a[7]);
    b[4] = inv_det * (a[0]*a[8] - a[2]*a[6]);
    b[8] = inv_det * (a[0]*a[4] - a[1]*a[3]);
    b[1] = b[3] = -inv_det * (a[3]*a[8] - a[5]*a[6]);
    b[2] = b[6] = inv_det * (a[3]*a[7] - a[4]*a[6]);
    b[5] = b[7] = -inv_det * (a[0]*a[7] - a[1]*a[6]);

    return;
}
