// Kinetochore Microtubule repulsive harmonic potential

#include "bob.h"

#include "kinetochore.h"
#include "minimum_distance.h"

#include <iostream>

double kc_mt_harmonic_potential(system_parameters *parameters, system_properties *properties,
                           double **f_bond, double **virial, double **t_bond, int *calc_matrix) {
    double u = 0.0;

    // Set up shortcuts
    int ndim = parameters->n_dim;
    int nperiodic = parameters->n_periodic;
    int n_bonds = properties->bonds.n_bonds;
    int nkcs = properties->chromosomes.nkcs_;
    double k = 20.0;
    double **h = properties->unit_cell.h;
    double **r_bond = properties->bonds.r_bond;
    double **s_bond = properties->bonds.s_bond;
    double **u_bond = properties->bonds.u_bond;
    double *l_bond = properties->bonds.length;
    double **f_kc = properties->chromosomes.f_;

    std::cout << "ERROR, not currently working!!!!\n";
    exit(1);

    if (properties->control.virial_flag)
        memset(virial[0], 0, ndim * ndim * sizeof(double));
    memset(f_bond[0], 0, n_bonds * ndim * sizeof(double));
    memset(t_bond[0], 0, n_bonds * 3 * sizeof(double));

    // Determine the cutoff distance (0.5*sigmamt + 0.5*sigmakc) XXX FIXME use real MT dia
    double r_cutoff = (0.5 * properties->chromosomes.kc_diameter_ + 0.5 * 1.0);
    double r_cutoff2 = SQR(r_cutoff);

    //std::cout << "KC MT harmonic potential\n";
    //std::cout << "   r_cutoff: " << r_cutoff << std::endl;

    // I guess loop over the bonds on the outer loop
    // XXX FIXME: More efficient way to do this?
    for (int ibond = 0; ibond < n_bonds; ++ibond) {
        // Loop over kinetochores
        for (int ikc = 0; ikc < nkcs; ++ikc) {
            // Now do the force calc
            double rmin[3] = {0.0};
            double rminmag2 = 0.0;
            double mu = 0.0;
            double *s_ = NULL;
            min_distance_sphere_sphero(ndim,
                                       nperiodic,
                                       h,
                                       properties->chromosomes.kinetochores_[ikc].r_,
                                       s_,
                                       r_bond[ibond],
                                       s_bond[ibond],
                                       u_bond[ibond],
                                       l_bond[ibond],
                                       rmin,
                                       &rminmag2,
                                       &mu);

            // Check if interacting
            if (rminmag2 < r_cutoff2) {
                //std::cout << "   MT[" << ibond << "] KC[" << ikc << "]:\n";
                //std::cout << "   rmin: (" << rmin[0] << ", " << rmin[1] << ", " << rmin[2] << ")\n";
                //std::cout << "   rminmag2: " << rminmag2 << std::endl;
                //std::cout << "   mu: " << mu << std::endl;

                // Woohoo, we have an interaction, now calculate it
                // Remember, repulsive interaction
                double f[3] = {0.0};
                // rmin takes into account the distance to the center, which we don't care about
                // so we need an effective rest length
                double factor = k * (1.0 - r_cutoff / sqrt(dot_product(ndim, rmin, rmin)));
                // Calculate forces
                for (int i = 0; i < ndim; ++i) {
                    f_bond[ibond][i] = -factor * rmin[i];
                    f_kc[ikc][i] += factor * rmin[i];
                }
                u += 0.5 * dot_product(ndim, f_bond[ibond], f_bond[ibond]) / k;

                //std::cout << "   f: (" << f_bond[ibond][0] << ", "
                //                       << f_bond[ibond][1] << ", "
                //                       << f_bond[ibond][2] << ")\n";

                // Calculate torques
                double rcontact[3] = {0.0};
                for (int i = 0; i < ndim; ++i) {
                    rcontact[i] = u_bond[ibond][i] * mu;
                }
                double tau[3] = {0.0};
                cross_product(rcontact, f_bond[ibond], tau, ndim);
                for (int i = 0; i < 3; ++i) {
                    t_bond[ibond][i] = tau[i];
                }

                // XXX FIXME Virial contribution???

                // Calc matrix
                calc_matrix[ibond] = 1;
            }
        }
    }

    return u;
}
