#include "bob.h"

#include "kinetochore.h"

#include <iostream>

double kc_wall_wca_potential(system_parameters *parameters, system_properties *properties,
                                double **f_bond, double **virial, double **t_bond, int *calc_matrix)
{
    double u = 0.0;

    // Setup shortcuts
    int ndim = parameters->n_dim;
    int n_bonds = properties->bonds.n_bonds;
    double **f_chromosome = properties->chromosomes.f_;

    if (properties->control.virial_flag)
        memset(virial[0], 0, ndim * ndim * sizeof(double));
    memset(f_bond[0], 0, n_bonds * ndim * sizeof(double));
    memset(t_bond[0], 0, n_bonds * 3 * sizeof(double));

    double sigma = 0.5 * (1.0 + properties->chromosomes.kc_diameter_);
    double r_cutoff = pow(2, 1.0/6.0) * sigma;
    double conf_rad = 0.5 * properties->unit_cell.h[0][0] - r_cutoff + 1.0;
    double conf_rad_2 = SQR(conf_rad);

    //std::cout << "KC-wall WCA\n";
    //std::cout << "   sigma: " << sigma << std::endl;
    //std::cout << "   r_cut: " << r_cutoff << std::endl;
    //std::cout << "   conf_rad: " << conf_rad << std::endl;
    //std::cout << "   conf_rad_2:" << conf_rad_2 << std::endl;

    for (int ikc = 0; ikc < properties->chromosomes.nkcs_; ++ikc) {
        //std::cout << "   [" << ikc << "]\n";
        double rmag2 = 0.0;
        for (int i = 0; i < ndim; ++i) {
            rmag2 += SQR(properties->chromosomes.kinetochores_[ikc].r_[i]);
        }
        //std::cout << "   rmag2: " << rmag2 << std::endl;

        if (rmag2 > conf_rad_2) {
            double rmag = sqrt(rmag2);
            double dr = -rmag + conf_rad + r_cutoff;

            double rho2 = SQR(sigma/dr);
            double rho6 = CUBE(rho2);
            double rho12 = SQR(rho6);
            double factor = 24.0 * (2.0 * rho12 - rho6) * rho2;

            //std::cout << "   force0: (" << f_chromosome[ikc][0] << ", "
            //                            << f_chromosome[ikc][1] << ", "
            //                            << f_chromosome[ikc][2] << ")\n";

            for (int i = 0; i < ndim; ++i) {
                f_chromosome[ikc][i] += -factor * dr * properties->chromosomes.kinetochores_[ikc].r_[i] / rmag; 
            }

            // Add contribution to virial
            if (properties->control.virial_flag) {
                for (int i = 0; i < ndim; ++i) {
                    for (int j = 0; j < ndim; ++j) {
                        virial[i][j] += -factor * dr * dr * properties->chromosomes.kinetochores_[ikc].r_[i] / rmag;
                    }
                }
            }

            //std::cout << "   force1: (" << f_chromosome[ikc][0] << ", "
            //                            << f_chromosome[ikc][1] << ", "
            //                            << f_chromosome[ikc][2] << ")\n";

            u += 4.0 * (rho12 - rho6) + 1.0;
        }
    }

    return u;
}
