#ifndef _KINETOCHORE_H_
#define _KINETOCHORE_H_

class ChromosomeManagement;
#ifndef _TRIANGLE_MESH_H_
typedef struct _triangle_mesh triangle_mesh;
#endif

class Kinetochore {

  public:

    Kinetochore();
    void Init(ChromosomeManagement *parent,
              int idx,
              int cidx,
              bool *sister,
              double *r,
              double *u,
              double *ueff,
              double *v,
              double *w,
              double vshift = 0.0);
    void ReInit();
    void PrintFrame();
    void ConsistencyCheck();


    float *GetColor();
    float *GetColorAF();
    double GetDrawDiameter();
    void CreateRefVectors(double vshift = 0.0);
    void CreateBindingSites_old();
    void CreateBindingSites();
    void CreateKinetochoreTriangulation();

    void Update_1_2(int ndim,
                    int nperiodic,
                    int nbonds,
                    double **h,
                    double **rbond,
                    double **sbond,
                    double **ubond,
                    double *lbond);
    double Stage_1_2_Probability(double rminmag2,
                                 double lline);
    double Stage_1_2_Probability(int n_dim,
                                 int ibond,
                                 bool tip,
                                 double *dr,
                                 double *uline,
                                 double length2);
    bool Insert_1_2(system_parameters *parameters,
                    system_properties *properties);
    bool Convert_1_2(system_parameters *parameters,
                     system_properties *properties,
                     int ibond,
                     int isite,
                     bool tip);
    bool Remove_2_1(system_parameters *parameters,
                    system_properties *properties);
    int Remove_2_1_Fdep(system_parameters *parameters,
                        system_properties *properties);
    double CalcForceHarmonic(int ndim,
                             int nperiodic,
                             double **h,
                             int isite,
                             double *rbond,
                             double *sbond,
                             double *ubond,
                             double lbond,
                             double *f,
                             double *t);
    double CalcForceQuartic(int ndim,
                            int nperiodic,
                            double **h,
                            int isite,
                            double *rbond,
                            double *sbond,
                            double *ubond,
                            double lbond,
                            double *f,
                            double *t);
    void UpdateSiteVector(int ndim,
                          int nperiodic,
                          double **h,
                          int isite,
                          double *rbond,
                          double *sbond,
                          double *ubond,
                          double lbond);
    void Step(int ndim,
              int nperiodic,
              int nbonds,
              double **h,
              double **rbond,
              double **sbond,
              double **ubond,
              double *lbond,
              double delta,
              gsl_rng *r);

    void Allocate();

    // Create and update the neighbor list for this kinetochore (actually, sites)
    void UpdateNeighbors(int ndim,
                         int nperiodic,
                         int nbonds,
                         double **h,
                         double **rbond,
                         double **sbond,
                         double **ubond,
                         double *lbond,
                         double rcutoff2);
    void ClearNeighbors(int isite);

    // Some helper functions for things
    bool ForceAttach(system_parameters *parameters,
                     system_properties *properties,
                     std::vector<int>& bondlist);
    bool ForceAttachSingle(system_parameters *parameters,
                           system_properties *properties,
                           int ibond,
                           int isite);
    void ForceUnbind(system_parameters *parameters,
                     system_properties *properties);

    // Determine our attachment status
    void DetermineAttachmentStatus(system_parameters *parameters,
                                   system_properties *properties);

  private:

    double RandomPosition(int ndim,
                          int nperiodic,
                          int ibond,
                          bool tip,
                          double **h,
                          double *r1,
                          double *s1,
                          double *rline,
                          double *sline,
                          double *uline,
                          double lline,
                          double kb,
                          gsl_rng *r);
    double RandomPositionOld(int ndim,
                          int nperiodic,
                          int ibond,
                          bool tip,
                          double **h,
                          double *r1,
                          double *s1,
                          double *rline,
                          double *sline,
                          double *uline,
                          double lline,
                          double kb,
                          gsl_rng *r);

    double (*prob_1_2_func) (double *x, void *params, int *pstatus, gsl_integration_workspace *w); 

  public:

    bool *second_sister_; // am I the second sister or not?
    bool trip_update_on_removal_ = false; // did we trip an update by removing a site?

    int idx_ = -1; // my id in the list from the parent
    int cidx_ = -1; // which chromosome I am part of
    int nsites_ = -1; // how many af complexes?
    int nbonds_ = -1; // how many microtubules
    int nverts_ = 6; // number of verticies in triangular mesh
    int force_type_ = 0; // What force type are we using on the AFs
                         // 0 = harmonic
                         // 1 = quartic
    int nmt_per_spb_ = 1; // Number of MTs per SPB (not asymmetric!!!!)

    double n_exp_tot_ = 0.0; // total for all sites

    // Main fuzzy ball stuff
    int *attach_; // attachment indicies for sites
    int *attach_status_; // overall attachment status
    double *r_; // pointers back up to main locations
    double *u_;
    double *ueff_;
    double *v_;
    double *w_;
    double *n_exp_; // "raw" probability density (per t) for attaching to
                    // any nearby spherocylinder
    double *cross_pos_; // linear position on bond for isite
    double *upot_; // potential energy in isite
    double *feff_; // effective force on isite, which gives us force dpeendent rate kinetics
    double *fangular_; // effective angular torque on the kinetochore to get force dep rate kinetics
    double *lbond_last_; // last known length of the ibond for each site, if attached
    double **dr_tot_; // total accumulator for sites
    double **r_cross_; // site cross vector (from site to bond attachment)
    double **flink_; // force vector for isite

    // special stuff for triangle mesh
    double **vertex_rel_; // relative vertex location

    // My particular anchor entry, neighbors, etc
    al_list *anchors_;
    nl_list *neighbors_; // Neighbors for attachment
    triangle_mesh *tri_;

  private:

    int ndim_ = 0;

    ChromosomeManagement *parent_;
};

#endif
