#include "bob.h"

void local_order_cl(system_parameters *parameters, system_properties *properties) {
    int n_dim, i_bond, j_bond;
    double n_bonds;
    double *local_order;
    double **u_bond;
    nl_list *neighbs;

    static double *full_Z;
    static int first_call = 1;

    n_dim = parameters->n_dim;
    n_bonds = properties->bonds.n_bonds;
    local_order = properties->bonds.local_order;
    u_bond = properties->bonds.u_bond;
    neighbs = properties->neighbors.neighbs;

    if (first_call) {
        full_Z = (double*) allocate_1d_array(n_bonds, sizeof(double));
        first_call = 0;
    }

    memset(local_order, 0, n_bonds*sizeof(double));
    memset(full_Z, 0, n_bonds*sizeof(double));

    for (i_bond = 0; i_bond < n_bonds; ++i_bond) {
        for (nl_list::iterator p = neighbs[i_bond].begin();
             p < neighbs[i_bond].end();
             ++p) {

            if (p->value > 0.0) {
                j_bond = p->label;
                double uiuj = dot_product(n_dim, u_bond[i_bond], u_bond[j_bond]);
                local_order[i_bond] += uiuj * p->value;
                local_order[j_bond] += uiuj * p->value;
                full_Z[i_bond] += p->value;
                full_Z[j_bond] += p->value;
            }

        }
    }

    for (i_bond = 0; i_bond < n_bonds; ++i_bond) {
        if (full_Z[i_bond] != 0.0)
            local_order[i_bond] /= full_Z[i_bond];
    }

}
