#ifndef _LOOKUP_TABLE_H
#define _LOOKUP_TABLE_H
#include <vector>
#include <string>

class LookupTable {
 public:
    int n_dim_;
    
    std::vector<int> n_grid_;
    std::vector<int> i_bin_;
    
    std::vector<double> *x_;
    std::vector<double> table_; 
    
 public:
    void Init(int n_dim, std::vector<double> *x, 
              double (*func) (std::vector<double> &x, void *params),
              void *params);
    void PrintTable();
    
    void OutputBinary(std::string outfile);

    inline int LinearIndex(int i_bin) {
        return i_bin_[0] * n_grid_[1] + i_bin_[1];
    };

    inline void Lookup(std::vector<double> &pos) {
        Lookup(pos.data());
    };
    
    double Lookup(double *x);

    void OutputInterpolatedGrid(std::vector<double> *x,
                                std::string outfile);

    double Invert(int dim, double u, double val[]);
    double Lookup(double x, double y);
};
    
#endif
