/* This routine computes the inverse of a square matrix.

   Input: size of square matrix (n)
          matrix for which to compute inverse (a)

   Output: inverse of matrix (a_inv) */

#include "bob.h"

void matrix_inversion(int n, double **a, double **a_inv)
{
    int i, j, *index;
    double **a_shift, **a_inv_shift, d, *col;

    /* Allocate memory for local arrays. */
    a_shift = dmatrix(1, n, 1, n);
    a_inv_shift = dmatrix(1, n, 1, n);
    col = dvector(1, n);
    index = ivector(1, n);

    /* Shift matrix to employ Numerical Recipes convention. */
    for (i = 1; i <= n; ++i)
        for (j = 1; j <= n; ++j)
            a_shift[i][j] = a[i - 1][j - 1];

    /* Use LU decomposition to compute inverse column by column. */
    ludcmp(a_shift, n, index, &d);
    for (j = 1; j <= n; ++j) {
        for (i = 1; i <= n; ++i)
            col[i] = 0.0;
        col[j] = 1.0;
        lubksb(a_shift, n, index, col);
        for (i = 1; i <= n; ++i)
            a_inv_shift[i][j] = col[i];
    }
    for (i = 1; i <= n; ++i)
        for (j = 1; j <= n; ++j)
            a_inv[i - 1][j - 1] = a_inv_shift[i][j];

    /* Free memory. */
    free_ivector(index, 1, n);
    free_dvector(col, 1, n);
    free_dmatrix(a_inv_shift, 1, n, 1, n);
    free_dmatrix(a_shift, 1, n, 1, n);

    return;
}
