#ifndef _MINIMUM_DISTANCE_H
#define _MINIMUM_DISTANCE_H

#ifndef _TRIANGLE_MESH_H_
typedef struct _triangle_mesh triangle_mesh;
#endif

void min_distance_point_carrier_line(int n_dim, int n_periodic, double **h,
                                     double *r_point, double *s_point,
                                     double *r_line, double *s_line, double *u_line,
                                     double length, double *dr, double *mu);

void min_distance_sphero(int n_dim, int n_periodic, double **h,
                         double *r_1, double *s_1, double *u_1, double length_1,
                         double *r_2, double *s_2, double *u_2, double length_2,
                         double *r_min, double *r_min_mag2, double *lambda, double *mu);

void min_distance_sphero_dr(int n_dim, int n_periodic, double **h,
                            double *r_1, double *s_1, double *u_1, double length_1,
                            double *r_2, double *s_2, double *u_2, double length_2,
                            double *dr, double *r_min, double *r_min_mag2, 
                            double *lambda, double *mu);

void min_distance_sphere_sphero(int n_dim, int n_periodic, double **h,
                                double *r_1, double *s_1,
                                double *r_2, double *s_2, double *u_2, double length_2,
                                double *r_min, double *r_min_mag2, double *mu);

void min_distance_sphero_plane(double *r_bond, double *u_bond, double length,
                               double *r_plane, double *n_plane, double *lambda,
                               double *r_min_mag2, double *r_min);


void min_distance_carrier_lines(int n_dim, int n_periodic, double **h,
                                double *r_1, double *s_1, double *u_1, 
                                double *r_2, double *s_2, double *u_2, 
                                double *r_min, double *r_min_mag2, 
                                double *lambda, double *mu);

void min_distance_sphere_disk(int n_dim, int n_periodic, double **h,
                              double *r_1, double *s_1, double *u_1, double radius_1,
                              double *r_2, double *s_2,
                              double *r_min, double *r_min_mag2, double *r_contact);

void min_distance_sphero_polygon(int n_dim, int n_periodic, double **h,
                                 double *r_1, double *s_1, double *u_1, double length_1,
                                 triangle_mesh *tri,
                                 double *rmin, double *rminmag2, double *rcontact,
                                 double *mu);

#endif
