#ifndef _NEIGHBORS_H
#define _NEIGHBORS_H
#include <vector>

/* The <nl_entry> structure contains variables necessary for our implementation 
   of neighbor lists. */
typedef struct nl_entry {
    int label;                  /* Label of item in list. */
    double value;               /* Value associated between label and entry
                                   (implemented for partition function tracking without
                                   adding extra complicated machinery.) */
    double dr[3];               /* Vector center to center displacement */
    double r_min_mag2;
    bool duplicate_ = false;    // Are we a duplicated entry for tip tracking?
} nl_entry;

typedef std::vector<nl_entry> nl_list;
/* The <neighbor_list> structure contains variables and arrays associated with neighbor lists. */
typedef struct {
    nl_list *neighbs;
} neighbor_list;

#endif
