#ifndef _PARAMETERS_H
#define _PARAMETERS_H
/* The <system_parameters> structure contains thermodynamic, control, and
   configuration parameters for the simulation. */

typedef struct {

   int n_dim;		/* number of spatial dimensions */

   int n_periodic;		/* number of periodic dimensions */

   int n_steps;		/* number of integration timesteps */

   int n_spheres;		/* number of spheres */

   int n_spheros;		/* number of spherocylinders */

   int n_anchors;		/* number of anchors */

   int n_layers;		/* number of smectic layers */

   double sphero_length;		/* spherocylinder length */

   double sphere_diameter;		/* sphere diameter */

   double side_length;		/* sidelength of hypercubic simulation cell */

   double x_side_length;		/* x sidelength of orthorhombic simulation cell */

   double y_side_length;		/* y sidelength of orthorhombic simulation cell */

   double z_side_length;		/* z sidelength of orthorhombic simulation cell */

   double cone_angle;		/* cone angle (in degrees) for de Vries cone model */

   int ghost_sphere_flag;		/* if ghost_sphere_flag == 1, spheres do not interact with one another */

   int square_well_line_flag;		/* if square_well_line_flag == 1, include square well line interaction */

   double well_diameter;		/* diameter of square well for square well line potential */

   double well_depth;		/* depth of square well for square well line potential */

   int wca_flag;		/* if wca_flag == 1, use wca potential */

   double k_sphero;		/* spherocylinder spring constant */

   int sphere_draw_flag;		/* draw circles/spheres if sphere_draw_flag == 1 */

   int n_plus;		/* number of plus-directed tubules */

   int n_interchange;		/* number of tubule interchange moves per MC cycle */

   int mutate_flag;		/* mutation flag (1 = modify molecular properties/geometry over course of simulation) */

   int mutate_label;		/* label of geometrical parameter to modify */

   int constraint_flag;		/* constraint flag (0 = bond lengths unconstrained, 1 = bond lengths constrained) */

   int n_cycles;		/* number of Monte Carlo cycles */

   int n_sites;		/* number of interaction sites */

   int max_trials;		/* maximum number of trial insertions */

   int neighb_switch;		/* neighbor search option (0 = all pairs, 1 = cell lists, 2 = neighbor lists) */

   int inter_neighb_switch;		/* neighbor search option for interaction sites (0 = all pairs, 1 = cell lists, 2 = neighbor lists) */

   int nl_update_flag;		/* neighbor list update option (0 = all pairs, 1 = cell lists) */

   int pair_flag;		/* pair interaction flag (0 = site-site, 1 = bond-bond) */

   int n_shell_lj;		/* search range for cell search algorithm (lj potential) */

   int lj_cell_list;		/* label of cell list for computing lj interactions */

   int n_shell_soft;		/* search range for cell search algorithm (soft sphere potential) */

   int soft_cell_list;		/* label of cell list for computing soft sphere interactions */

   int n_shell_nl;		/* search range for cell search algorithm (neighbor list update) */

   int nl_cell_list;		/* label of cell list for updating neighbor lists */

   double density;		/* number density */

   double scale_factor;		/* scale factor for crystal builder */

   double temp;		/* temperature */

   double temp_time;		/* time constant for thermostat */

   int temp_flag;		/* flag controlling sampling of site velocities */

   int thermostat_option;		/* thermostat option (0 = none, 1 = berendsen, 2 = nose-hoover) */

   double press;		/* pressure */

   double press_init;		/* initial pressure (for pressure sweep) */

   double press_final;		/* final pressure (for pressure sweep) */

   double press_time;		/* time constant for barostat */

   int barostat_option;		/* barostat option (0 = none, 1 = berendsen) */

   int ortho_scaling;		/* orthorhombic constraint for barostat (0 = unconstrained, 1 = orthorhombic) */

   double delta;		/* integration timestep */

   double aspect_ratio;		/* aspect ratio */

   double skin;		/* neighbor list skin */

   long seed;		/* seed for random number generator */

   char *species_file;		/* name of file containing list of molecular species */

   int start_option;		/* initial condition option (0 = read from file, 1 = fcc-like) */

   char *system_file;		/* name of system configuration file */

   char *config_file;		/* name of input configuration file */

   char *unit_cell_file;		/* name of file containing unit cell vectors */

   char *basis_file;		/* name of file containing scaled positions of sites in unit cell */

   char *lattice_file;		/* name of file containing lattice configuration matrix */

   int n_posit;		/* interval for writing positions to trajectory file */

   int n_thermo;		/* interval for writing thermodynamic quantities to thermodynamics file */

   int n_block;		/* interval for computing block averages of thermodynamic quantities */

   int n_graph;		/* interval for displaying configurations */

   int graph_flag;		/* graphic display flag (0 = graphics off, 1 = graphics on) */

   int step_flag;		/* step flag (0 = no repulsive step interactions, 1 = repulsive step interactions) */

   int hard_core_flag;		/* hard core flag (0 = no hard core interactions, 1 = hard core interactions) */

   int dipole_flag;		/* dipole flag (0 = no dipole interactions, 1 = dipole interactions) */

   double binding_energy;		/* binding energy for sticky cylinders */

   double diameter;		/* sticky cylinder diameter */

   double r_cutoff;		/* interaction range for sticky cylinders (generalized ramp potential) */

   double exponent;		/* interaction exponent for sticky cylinders (generalized ramp potential) */

   int square_well_flag;		/* square well flag for sticky cylinders (0 = generalized ramp potential, 1 = square well potential) */

   int flip_flag;		/* flip move flag for sticky cylinder MC simulation */

   int n_flip;		/* number of flip moves per MC cycle for sticky cylinder MC simulation */

   int cluster_flag;		/* cluster move flag */

   int n_cluster;		/* number of cluster moves per MC cycle */

   double cluster_cutoff;		/* proximity criterion for defining clusters */

   double target_cluster_size;		/* target average cluster size (used to adjust cluster_cutoff) */

   double clust_displ_max;		/* maximum cluster displacement */

   double clust_spin_max;		/* maximum rotation angle (in radians) for cluster 'spin' moves */

   double clust_flip_max;		/* maximum rotation angle (in radians) for cluster 'flip' moves */

   double clust_spin_prob;		/* relative probability of cluster 'spin' vs. 'flip' rotational moves */

   double sigma_core;		/* diameter of hard core */

   double sigma_step;		/* diameter of repulsive step */

   double sigma_step2;		/* diameter of second repulsive step */

   double epsilon_step;		/* height of repulsive step */

   double epsilon_step2;		/* height of second repulsive step */

   double epsilon_ramp;		/* height of repulsive ramp */

   double sigma_ramp;		/* diameter of repulsive ramp */

   double exponent_ramp;		/* exponent for repulsive generalized ramp potential */

   double exponent_gauss;		/* exponent for repulsive squeezed gaussian potential */

   double sigma_gauss;		/* width of repulsive squeezed gaussian potential */

   double epsilon_gauss;		/* height of repulsive squeezed gaussian potential */

   double sigma_well;		/* diameter of attractive well */

   double r_cutoff_lj;		/* interaction cutoff for lj potential */

   double r_cutoff_gauss;		/* interaction cutoff for squeezed gaussian potential */

   double r_cutoff_soft;		/* interaction cutoff for soft sphere potential */

   double exponent_soft;		/* exponent for soft sphere potential */

   double epsilon_attractive;		/* strength of attractive power law potential */

   double cutoff_tolerance;		/* tolerance for interaction potential at cutoff */

   double exponent_repulsive;		/* exponent for repulsive power law potential */

   double exponent_attractive;		/* exponent for attractive power law potential */

   double r_cutoff_pow;		/* interaction cutoff for power law potential */

   double sigma_stretch;		/* width of repulsive stretched exponential potential */

   double exponent_stretch;		/* exponent for repulsive stretched exponential potential */

   double r_cutoff_stretch;		/* interaction cutoff for stretched exponential potential */

   double dipole_cutoff;		/* interaction cutoff for dipole potential */

   double torque_density;		/* torque density per unit length for chiral ratchet model */

   double force_density;		/* force density per unit length for motility model */

   double u_shift_soft;		/* interaction cutoff shift for soft sphere potential */

   int n_shell_core;		/* search range for cell search algorithm (hard core) */

   int n_shell_step;		/* search range for cell search algorithm (repulsive step) */

   int n_shell_step2;		/* search range for cell search algorithm (second repulsive step) */

   int n_shell_ramp;		/* search range for cell search algorithm (repulsive ramps) */

   int n_shell_gauss;		/* search range for cell search algorithm (squeezed gaussian potential) */

   int n_shell_stretch;		/* search range for cell search algorithm (stretched exponential potential) */

   int n_shell_dipole;		/* search range for cell search algorithm (dipole potential) */

   int n_shell_well;		/* search range for cell search algorithm (attractive well potential) */

   int cyl_cell_list;		/* label of cell list for finding overlaps between hard cylinders */

   int n_shell_cyl;		/* search range for cell search algorithm (hard cylinders) */

   int core_cell_list;		/* label of cell list for finding overlaps between hard cores */

   int step_cell_list;		/* label of cell list for finding overlaps between repulsive steps */

   int step_cell_list2;		/* label of cell list for finding overlaps between second repulsive steps */

   int ramp_cell_list;		/* label of cell list for finding overlaps between repulsive ramps */

   int gauss_cell_list;		/* label of cell list for computing repulsive squeezed gaussian interactions */

   int stretch_cell_list;		/* label of cell list for computing repulsive stretched exponential interactions */

   int dipole_cell_list;		/* label of cell list for computing dipolar interactions */

   int well_cell_list;		/* label of cell list for computing attractive well interactions */

   int supercell_flag;		/* supercell flag (0 = supercells not used, 1 = supercells used) */

   int step_supercell_list;		/* label of supercell list for computing repulsive step interactions */

   int step_supercell_list2;		/* label of supercell list for computing second repulsive step interactions */

   int core_supercell_list;		/* label of supercell list for computing hard core interactions */

   double accuracy;		/* relative accuracy of pair interactions */

   double displ_max;		/* maximum site/bond displacement */

   double displ_par_max;		/* maximum site/bond displacement parallel to symmetry axis/wavevector */

   double displ_perp_max;		/* maximum site/bond displacement perpendicular to symmetry axis/wavevector */

   double rot_max;		/* maximum bond/cylinder rotation */

   int exp_dist_flag;		/* flag controlling displacement distribution (0 = uniform, 1 = exponential) */

   int scale_flag;		/* volume scaling flag for MC (0 = NVT MC, 1 = NPT MC) */

   double scale_max;		/* maximum volume scaling factor */

   char *scaling_file;		/* name of file containing unit cell scaling matrix (for NPT MD and MC) */

   int n_opt;		/* interval for optimizing Monte Carlo procedure */

   int opt_flag;		/* optimization flag (0 = no optimization, 1 = optimization) */

   int grab_flag;		/* frame grabber flag (0 = do not grab frame, 1 = grab frame) */

   char *grab_file;		/* root name of file to save frame into */

   double x_rot_rate;		/* rotation 'rate' around x axis */

   double y_rot_rate;		/* rotation 'rate' around y axis */

   double z_rot_rate;		/* rotation 'rate' around z axis */

   char *color_file;		/* name of file containing color definitions */

   char *struct_file;		/* name of file containing molecular structure */

   char *lj_file;		/* name of file containing Lennard-Jones parameters */

   char *ramp_file;		/* name of file containing ramp potential parameters */

   char *soft_sphere_file;		/* name of file containing soft sphere parameters */

   char *stretch_file;		/* name of file containing bond stretch parameters */

   char *bend_file;		/* name of file containing bond angle bend parameters */

   char *mass_file;		/* name of file containing site masses */

   char *pot_file;		/* name of file containing attributes of external periodic potential */

   double bin_size;		/* size of bins for pair distribution function */

   double r_equil_cross;		/* equilibrium crosslink length */

   double k_stretch_cross;		/* crosslink stretch spring constant */

   double v_cross;		/*          crosslink velocity */

   double f_stall_cross;		/*          crosslink stall force */

   int widom_flag;		/* Widom test particle insertion flag (0 = off, 1 = on) */

   int n_widom;		/* number of test particle insertions per MC cycle */

   int block_cycles;		/* number of MC cycles per block for block average uncertainty estimation */

   double r_floop;		/* radius of 'floop' region */

   double p_floop;		/* 'floop' rate inside 'floop' region */

   double p_unfloop;		/* 'unfloop' rate outside 'floop' region */

   int pair_interaction_flag;		/*             turns on and off pair interactions for various tests */

   int order_type;		/*             which way to build a sphero fluid, 0 for isotropic, 1 is nematic, 2 for crystalline  */

   int rotate_flag;		/*             if one, brownian spheres will be allowed to rotate diffusively  */

   int poly_dist_type;		/*             length distribution for fluid_builder_sphero, 0 is uniform random, 1 for exponential with mean of sphero_length but truncated, 2 for uniform and truncated */

   int sphere_flag;		/*              centers of mass within a sphere for the sphero fluid if 1 */

   int dynamic_instability_flag;		/*             Incorporate dynamic instability into spherocylinder dynamics  */

   int color_switch;		/*              Color spherocylinders according to orientation. 2 gives HSV scheme for polar molecules in 3d  */

   double viscosity;		/*           viscosity of fluid for brownian dynamics sims  */

   char *crosslink_file;		/*           file determining various crosslink properties  */

   int diffusion_flag;		/*              measure diffusion during simulation  */

   int motility_flag;		/*              drive spherocylinders along their long axis  */

   int nl_twoway_flag;		/*              if true, in neighbor lists store i_bond -> j_bond as well as j_bond -> i_bond (for MC mostly)  */

   double min_length;		/*           minimum length for polydisperse rod system */

   double max_length;		/*           maximum length for polydisperse rod system. cannot be bigger than half minimum box dimension */

   int end_detach;		/*              flag to remove crosslinks if they get to the end */

   int write_crosslink_flag;		/*              flag to output crosslink data periodically. final data will always be output regardless */

   int rand_orientation_flag;		/*              flag to randomly flip orientations of spherocylinders during building phase */

   int orient_flag;		/*              flag to include orientation information in fluid_builder */

   char *crosslink_config;		/*           initial crosslink configuration to begin simulation with */

   double f_shrink_to_grow;		/*           rescue frequency for dynamic instability */

   double f_shrink_to_pause;		/*           frequency of transitions from shrink state to pause state for dynamic instabiity */

   double f_grow_to_shrink;		/*           catastrophe frequency for dynamic instability */

   double f_grow_to_pause;		/*           frequency of transitions from grow state to pause state for dynamic instabiity */

   double f_pause_to_grow;		/*           rescue frequency from pause state for dynamic instability */

   double f_pause_to_shrink;		/*           catastrophy frequency from pause state for dynamic instability */

   double v_poly;		/*           polymerization velocity for dynamic instability */

   double v_depoly;		/*           depolymerization velocity (absolute value. positive values will shrink rods) */

   char *poly_config;		/*           input polymerization state config */

   int gaussian_cosine_flag;		/*              use gaussian cosine potential for sphere_bd routine */

   int n_overlaps;		/*              number of overlaps before exit in kc_capture */

   int pair_dist_flag;		/*              Measure lab frame pair correlation function */

   int pair_dist_axes_flag;		/*              Measure molecular axis frame pair correlation function */

   int pair_dist_radial_flag;		/*              Measure radial pair correlation function */

   int msd_flag;		/*              Measure mean squared displacement */

   int u_autocorr_flag;		/*              Measure orientational autocorrelation */

   int p_autocorr_flag;		/*              Measure local polarity order autocorrelation */

   int struct_factor_flag;		/*              Measure static structure factor */

   int cl_dist_flag;		/*              Measure crosslink distribution functions */

   int reorientation_flag;		/*              Allow reorientations in sphero_bd simulations */

   int box_check_flag;		/*              Safety check for interactions bigger than half system size */

   int press_flag;		/*              Measure various pressure quanties in post processing */

   double capture_diameter;		/*           Effective capture diameter for a sphere coming in contact wit a spherocylinder */

   double capture_length;		/*           Distance from plus end of spherocylinder where a kinetochore is considered attached */

   int lateral_capture;		/*              Effectively sets capture_length to spherocylinder length such that any contact along spherocylinder is a capture event */

   int diffusion_override_flag;		/*              Allow for overriding of calculated spherocylinder rotational diffusion */

   double diffusion_scale;		/*           scale factor for rotational diffusion. 1.0 would recover analytic results */

   double domain_cutoff;		/*           effective diameter of spherocylinders for polar domain identification */

   double domain_threshold;		/*           polar order parameters difference threshold for domain inclusion  */

   int use_spb_flag;		/*              flag to use spbs/anchors as site attachments, rather than the wall of the simulation */

   int crosslink_polar_affinity_flag;		/*  flag to tell crosslinks whether to preferentially bind to parallel or anti-parallel rods */

   int xlink_stage1_stabilization_flag;		/*      flag to tell spherocylinders undergoing dynamic instability to stabilize if crosslinked near plus tip by stage1 xlinks */

   int flock_flag;		/*              flag to analyze flock distributions */

   double alpha_temp;		/*           temperature scaling for simulated annealing */

   double press_min;		/*           minimum pressure for scan */

   double press_max;		/*           maximum pressure for scan */

   double sigma_min;		/*           minimum sigma for scan */

   double sigma_max;		/*           maximum sigma for scan */

   double sigma_inc;		/*           sigma increment */

   double press_inc;		/*           pressure increment */

   int scan_flag;		/*              implement pressure/sigma scanning */

   int n_spindle;		/*              number of steps before writing out spindle numbers */

   int contact_flag;		/*              measure contact number */

   int polar_trajectory_flag;		/*              measure polarity dependent trajectories */

   int n_walls;		/*              number of LJ walls for sphero bd sims */

   double target_polarity;		/*           polarity for fluid_builder_sphero */

   int pair_dist_polar_order_flag;		/*           measure spatial correlations of local order parameter */

   int child_list_flag;		/*              use child bonds for cell routines */

   double child_length;		/*           max length of child bonds */

   int mt_diffusion_flag;		/*              flag to tell mt to diffuse               */

   int force_induced_catastrophe_flag;		/*       flag to tell whether there is a force dependence on mt catastrophe frequency */

   int rigid_tether_flag;		/*              use rigid tethers for kc_capture */

   int omp_num_threads;		/*              set number of threads used by openmp programs */

   char *omp_schedule;		/*           set schedule type for openmp programs */

   int omp_chunksize;		/*              set schedule chunk size for openmp programs */

   int gomp_spincount;		/*              sets thread busy-wait spincount for openmp programs compiled with gcc */

   int kmp_blocktime;		/*              sets thread wait time in milliseconds for openmp programs compiled with icc */

   double wait_time;		/*           total amount of time to wait before spindle allowed to move */

   int wall_potential_flag;		/*              Changes the potential of the boundary of the system (0=None, 1=WCA, 2=exp asymptotic, 3=linear, 4=quadratic(not defined), 5=non-monotonic ) */

   double wall_force_factor;		/*           Wall force constant (for wall_potential_flag=3 or 5 this is the asymptotic value as dr goes to infinity) */

   int force_poly_flag;		/*              Flag to activate force depenedent growth velocity of MTs */

   double f_mt_stall;		/*           Stall force of MT polymerization    */

   char *data_analysis_file;		/*           Yaml file that initializes data collection class */

   double ne_ratio;		/*           The ratio between the membranes bending rigidity and surface tension in length^2 units (see PRL Formation and Interaction of Membrane Tubes) */

   double spb_diffusion;		/*           The diffusion coefficient for spindle pole bodies embedded in the the nuclear envelope */

   int graph_boundary_flag;		/*             Tell program to either graph or not to graph boundary of system (0 = Do not graph, 1 = graph) */

   char *chromosome_config;		/*           Configuration file for chormosome configuration */

   char *chromosome_output;		/*           Chromosome output file */

   int spb_angular_spring_flag;		/*              SPB angular spring flag turned on or off (0=off, 1=inward, 2=original orientation, 3=inward lens) */

   int crosslink_flag;		/*              flag to tell whether or not there are crosslinks in simulation */

   int boundary_type;		/*              specify boundary geometry (0 = free, 1 = cube, 2 = sphere) */

   int droplet_flag;		/*              fluid_sphero_builder adds spherocylinders to a smaller radius than the unit cell  */

   double droplet_rad;		/*           Define the radius of the droplet when droplet_flag parameter is 1. Must be less than half the unit cell length. */

   int xlink_test_flag;		/*              flag to test xlink properties in simple configurations */

   double thermal_diff_scale;		/*           The amount to scale thermal diffusion by for MTs and SPBs (0 to X) */

} system_parameters;
#endif
