/* This routine computes scaled coordinates and applies periodic boundary conditions
   to a set of objects (sites, bonds, molecules, etc.).

   Input: number of periodic spatial dimensions (n_periodic)
          number of objects (n_objects)
          unit cell matrix (h)
          inverse unit cell matrix (h_inv)
          array of real object coordinates (r)
          array of scaled object coordinates (s)

   Output: r and s are modified on output. */

#include "bob.h"

void periodic_boundary_conditions(int n_periodic, int n_objects, double **h, double **h_inv,
                                  double **r, double **s)
{
    int i_object;

    /* Loop over objects. For each object, compute scaled coordinates, apply periodic boundary conditions,
       and recompute real coordinates. */
    for (i_object = 0; i_object < n_objects; ++i_object)
        periodic_boundary_conditions_single(n_periodic, h, h_inv, r[i_object], s[i_object]);

    return;
}
