// Print out all information for this simulation step

#include "bob.h"

#include <iostream>
#include <iomanip>

void print_simulation_step(system_parameters *parameters,
                           system_properties *properties) {
    std::cout << "Printing Simulation Step: " << properties->i_current_step << std::endl;

    auto ndim = parameters->n_dim;
    auto rbond = properties->bonds.r_bond;
    auto ubond = properties->bonds.u_bond;

    // Print out all of the MT information
    std::cout << properties->bonds.n_bonds << " bonds\n";
    for (int ibond = 0; ibond < properties->bonds.n_bonds; ++ibond) {
        std::cout << "bond[" << ibond << "] ";
        std::cout << "r(" << rbond[ibond][0] << ", " << rbond[ibond][1];
        if (ndim == 3) {
            std::cout << ", " << rbond[ibond][2];
        }
        std::cout << ") ";
        std::cout << "u(" << ubond[ibond][0] << ", " << ubond[ibond][1];
        if (ndim == 3) {
            std::cout << ", " << ubond[ibond][2];
        }
        std::cout << ") ";
        std::cout << "l: " << properties->bonds.length[ibond];
        std::cout << std::endl;
    }

    //// Convert things into RTP (r theta phi) for the configuration
    ////double conf_rad = properties->unit_cell.h[0][0];
    //double conf_rad = 55.0;
    //int mts_per_spb = properties->bonds.n_bonds / properties->anchors.n_anchors;
    //        std::cout << std::setprecision(16);
    //for (int ispb = 0; ispb < properties->anchors.n_anchors; ++ispb) {
    //    // Print out information about the spindle pole body
    //    double theta = acos(properties->anchors.r_anchor[ispb][2]/conf_rad);
    //    double phi = atan2(properties->anchors.r_anchor[ispb][1], properties->anchors.r_anchor[ispb][0]);
    //    std::cout << "SPB[" << ispb << "] RTP(" << theta << ", " << phi << ")\n";
    //    for (int ibond = ispb*mts_per_spb; ibond < (ispb+1)*mts_per_spb; ++ibond) {
    //        double ibondadj = ibond - ispb*mts_per_spb;
    //        double bondtip[3] = {0.0};
    //        for (int i = 0; i < 3; ++i) {
    //            bondtip[i] = properties->bonds.r_bond[ibond][i] - 0.5 * (properties->bonds.length[ibond] - properties->anchors.r0[ispb]) * properties->bonds.u_bond[ibond][i];
    //        }
    //        theta = acos(bondtip[2]/conf_rad);
    //        phi = atan2(bondtip[1], bondtip[0]);
    //        //std::cout << "  MT[" << ibond << "] RTP(" << theta << ", " << phi << "), l: " << properties->bonds.length[ibond] << std::endl;
    //        //std::cout << "       u(" 
    //        //    << properties->bonds.u_bond[ibond][0] << ", " 
    //        //    << properties->bonds.u_bond[ibond][1] << ", "
    //        //    << properties->bonds.u_bond[ibond][2] << ")\n";

    //        //// Print out in a form that can be easily excahnged into yaml (for now)
    //        //std::cout << "  - insertion_type: RTP\n";
    //        //std::cout << "    theta: " << theta << std::endl;
    //        //std::cout << "    phi: " << phi << std::endl;
    //        //std::cout << "    length: " << properties->bonds.length[ibond] << std::endl;
    //        //std::cout << "    orient: ["
    //        //    << properties->bonds.u_bond[ibond][0] << ", "
    //        //    << properties->bonds.u_bond[ibond][1] << ", "
    //        //    << properties->bonds.u_bond[ibond][2] << "]\n";

    //        // Print out in a form that can be easily excahnged into yaml (for now)
    //        std::cout << "  - insertion_type: XYZ\n";
    //        std::cout << "    r: ["
    //            << properties->bonds.r_bond[ibond][0] << ", "
    //            << properties->bonds.r_bond[ibond][1] << ", "
    //            << properties->bonds.r_bond[ibond][2] << "]\n";
    //        std::cout << "    u: ["
    //            << properties->bonds.u_bond[ibond][0] << ", "
    //            << properties->bonds.u_bond[ibond][1] << ", "
    //            << properties->bonds.u_bond[ibond][2] << "]\n";
    //        std::cout << "    length: " << properties->bonds.length[ibond] << std::endl;
    //        std::cout << "    anchorpos: ["
    //            << properties->anchors.anchor_list[ispb][ibondadj].pos[0] << ", "
    //            << properties->anchors.anchor_list[ispb][ibondadj].pos[1] << ", "
    //            << properties->anchors.anchor_list[ispb][ibondadj].pos[2] << "]\n";
    //    }
    //}

    // Print out the crosslink information
    //properties->crosslinks.PrintSimulationStep();
}
