#ifndef _NAB_PROBABILITIES_H_
#define _NAB_PROBABILITIES_H_

#include <algorithm>
#include <cmath>
#include <map>
#include <vector>

#include <gsl/gsl_integration.h>

#include "helpers.h"

struct _integration_params {
    double alpha; // k/2 from linear spring
    double alpha2; // kr/2 from angular spring
    double r0; // rest length
    double y0; // min distance
    double xc; // characteristic distance
    double chic; // angular characteristic factor (unitless)
    double costhetaminA; // cosine of thetaminA (rmin dot ua)
    double costheta2A; // cosine of theta2A (u2 dot ua)
};
typedef struct _integration_params integration_params;
typedef struct _integration_params xlink_params;
typedef struct _integration_params kc_params;

// Advanced angular integral, see CJE work on linear+angular partition
// function calculation for kinetochore-microtubule attachments
double advanced_integrand_1_2(double x, void *params);
double advanced_integrand_1_2_quartic(double x, void *params);
double prob_1_2_advanced(std::vector<double> &x, void *params);
double prob_1_2_advanced_upper(std::vector<double> &x, void *params);
double prob_1_2_advanced_lower(std::vector<double> &x, void *params);

// New, full versions of the probabilities
double prob_1_2_advanced_full(double *x, void *params, int *pstatus, gsl_integration_workspace *w);
double prob_1_2_advanced_quartic(double *x, void *params, int *pstatus, gsl_integration_workspace *w);

// Original partition function calculation
double integrand_1_2(double x, void *params);

// Partition function calculation with force dependence
double integrand_1_2_fdep(double x, void *params);

// Invert based on a binary search with a tolerance
double InvertBinary(double u,
                    double *xvec,
                    double (*func) (double *x, void *params, int *pstatus, gsl_integration_workspace *w),
                    gsl_integration_workspace *w,
                    double tolerance,
                    void *params);

// Inverse transform sample based on the CDF of the distribution
double InverseTransformSample(double u,
                              double *xvec,
                              double lline,
                              double (*func) (double *x, void *params, int *pstatus, gsl_integration_workspace *w),
                              gsl_integration_workspace *w,
                              double tolerance,
                              void *params);

#endif
