void accum_dynamic_structure_factor(int n_dim, int n_linear, 
                                    int max_config, fftw_complex *out, 
                                    FILE *f_rho_k, FILE *f_scatter, int clear_flag);

void accum_dynamic_structure_factor_mmap(int n_dim, int n_objs, int n_linear, 
                                         int max_config, fftw_complex *in_rho_k, 
                                         int finish_flag);

void accum_structure_factor(int i_dim, int n_dim, int n_objects, int *i_bin, int *i_bin_shift,
                            int *n_bin, fftw_complex * out, double *struct_factor);

void *allocate_1d_array(size_t n, size_t size);
void **allocate_2d_array(size_t n1, size_t n2, size_t size);
void ***allocate_3d_array(size_t n1, size_t n2, size_t n3, size_t size);
void ****allocate_4d_array(size_t n1, size_t n2, size_t n3, size_t n4, size_t size);/* Function prototypes for bob (bunch o' balls/beads/bodies/blobs). */

void allocate_correlation_data(correlation_data *data);

double anchor_potential_bd(system_parameters *parameters, system_properties *properties,
                           double **f_bond, double **virial, double **t_bond, int *calc_matrix);
double chromosome_chromatin_potential(system_parameters *parameters, system_properties *properties,
                           double **f_bond, double **virial, double **t_bond, int *calc_matrix);
double chromosome_chromatin_potential_angular(system_parameters *parameters, system_properties *properties,
                           double **f_bond, double **virial, double **t_bond, int *calc_matrix);
double spb_spring_potential_angular(system_parameters *parameters, system_properties *properties,
                           double **f_bond, double **virial, double **t_bond, int *calc_matrix);
double kc_mt_harmonic_potential(system_parameters *parameters, system_properties *properties,
                           double **f_bond, double **virial, double **t_bond, int *calc_matrix);
double chromosome_mt_soft_gaussian_potential_allpairs(system_parameters *parameters, system_properties *properties,
                           double **f_bond, double **virial, double **t_bond, int *calc_matrix);
double kinetochore_mt_potential_allpairs(system_parameters *parameters, system_properties *properties,
                           double **f_bond, double **virial, double **t_bond, int *calc_matrix);
double kinetochoremesh_mt_wca_potential_allpairs(system_parameters *parameters, system_properties *properties,
                           double **f_bond, double **virial, double **t_bond, int *calc_matrix);
double kinetochoremesh_mt_wca_potential_neighbors(system_parameters *parameters, system_properties *properties,
                           double **f_bond, double **virial, double **t_bond, int *calc_matrix);
double kinetochorepoint_mt_wca_potential_allpairs(system_parameters *parameters, system_properties *properties,
                           double **f_bond, double **virial, double **t_bond, int *calc_matrix);

double anchor_wca_potential_bd(system_parameters *parameters, system_properties *properties,
                               double **f_bond, double **virial, double **t_bond, int *calc_matrix);
double anchor_lj_potential_bd(system_parameters *parameters, system_properties *properties,
                               double **f_bond, double **virial, double **t_bond, int *calc_matrix);

double antiparallel_overlap(int n_dim, int n_periodic, double **h,
                            double well_diameter,
                            double *r_1, double *s_1, double *u_1, double length_1,
                            double *r_2, double *s_2, double *u_2, double length_2);

void berendsen_barostat_sphero(system_parameters *parameters, system_properties *properties);

blocking_data blocking_analysis(double *data, int n);

void bond_position(int n_dim, int n_periodic, double **h, double **h_inv,
                   double **r, int site_1, double *v_bond, double *r_bond, double *s_bond);

void bond_vector(int n_dim, int n_periodic, double **h,
                 double **s, double **r, int site_1, int site_2,
                 double *v_bond, double *u_bond, double *length, double *length2);

double brownian_sphero_all_pairs(system_parameters *parameters, system_properties *properties,
                                 double **f_bond, double **virial, double **t_bond, int *calc_matrix);

double brownian_sphero_analysis(system_parameters *parameters, 
                                system_properties *properties,
                                double **f_bond, 
                                analysis_properties *analysis);

double brownian_sphero_neighbor_lists(system_parameters *parameters, system_properties *properties,
                                      double **f_bond, double **virial, double **t_bond, 
                                      int *calc_matrix);

double brownian_sphero_neighbor_lists_mp(system_parameters *parameters, system_properties *properties,
                                         double **f_bond, double **virial, double **t_bond, 
                                         int *calc_matrix);

void dump_simulation(system_parameters *parameters,
                     system_properties *properties,
                     std::string error_string);

void print_simulation_step(system_parameters *parameters,
                           system_properties *properties);

void calc_axes_bins_2d(double *dr, double *u_i, double *u_j, correlation_data *data,
                       int *i_linear, int *j_linear);

void calc_correlation_bin_info(correlation_data *data);

void calc_op_tensor(int n_dim, int n_bonds, double **u_bond, double *op_tensor_curr);

int check_neighbor_lists_sphero(system_parameters *parameters, system_properties *properties);

void check_neighbor_lists_sphero_mp(system_parameters *parameters, system_properties *properties);

void configurator_spb_dynamics(system_parameters *parameters,
							   system_properties *properties,
							   char *config_file);

void configurator_vesicles(system_parameters *parameters,
                           system_properties *properties,
                           YAML::Node &node);
void configurator_generic(system_parameters *parameters,
							   system_properties *properties,
							   char *config_file);

void configure_spb_dynamics(system_parameters *parameters,
							system_properties *properties,
							char *config_file);
void covsrt(double **covar, int ma, int ia[], int mfit);

double cpu(void);

void cross_product(double *a, double *b, double *c, int n_dim);

void crosslink_analysis(system_parameters *parameters, system_properties *properties,
                        analysis_properties *analysis, FILE *f_cl);

double crosslink_interaction_analysis(system_parameters *parameters, 
                                      system_properties *properties,
                                      double **f_bond, 
                                      analysis_properties *analysis);

double crosslink_interaction_bd(system_parameters *parameters,
                                system_properties *properties, double **f, 
                                double **virial, double **t_bond, int *calc_matrix);

double crosslink_interaction_bd_mp(system_parameters *parameters,
                                   system_properties *properties, double **f, 
                                   double **virial, double **t_bond, int *calc_matrix);
double af_mt_harmonic_potential(system_parameters *parameters,
                                system_properties *properties, double **f, 
                                double **virial, double **t_bond, int *calc_matrix);
double af_mt_quartic_potential(system_parameters *parameters,
                                system_properties *properties, double **f, 
                                double **virial, double **t_bond, int *calc_matrix);

int crosslink_move(system_parameters *parameters, system_properties *properties);

double determinant(int n, double **a);
int determinant_integer_matrix(int n, int **matrix);

double **dmatrix(long nrl, long nrh, long ncl, long nch);
void free_dmatrix(double **m, long nrl, long nrh, long ncl, long nch);

double dot_product(int n_dim, double *a, double *b);
void normalize_array(int n_dim, double *a);

void draw_2d_line_list(line_list *list, double **h);

double *dvector(long nl, long nh);
void free_dvector(double *v, long nl, long nh);

void init_dynamic_instability(system_parameters *parameters, system_properties *properties);

int dynamic_instability(system_parameters *parameters,
                        system_properties *properties,
                        system_potential *potential);

double dynamics_efficiency(int n_opt, double delta, double elapsed_time);
void eigsrt(double d[], double **v, int n);

void error_exit(const char *error_msg, ...);

void evaluate_forces_bd(system_parameters *parameters, system_properties *properties,
                        system_potential *potential);
void fit(double x[], double y[], int ndata, double sig[], int mwt, double *a,
         double *b, double *siga, double *sigb, double *chi2, double *q);
void lfit(double x[], double y[], double sig[], int ndat, double a[], int ia[],
          int ma, double **covar, double *chisq, void (*funcs) (double, double[], int));
void fourn(double data[], unsigned int nn[], int ndim, int isign);
void free_1d_array(void *ptr);
void free_2d_array(void **ptr, size_t n1);
void free_3d_array(void ***ptr, size_t n1, size_t n2);
void free_4d_array(void ****ptr, size_t n1, size_t n2, size_t n3);
void free_dmatrix(double **m, long nrl, long nrh, long ncl, long nch);
void free_dvector(double *v, long nl, long nh);
void free_imatrix(int **m, long nrl, long nrh, long ncl, long nch);
void free_ivector(int *v, long nl, long nh);
void free_lvector(unsigned long *v, long nl, long nh);
double gammln(double xx);
double gammq(double a, double x);

double qgauleg(double (*func) (double), double a, double b);
void gauleg(double x1, double x2, double x[], double w[], int n);

double gaussian_line_pair_potential(int n_dim, int n_periodic, double eps_eff, double **h,
                                    double k_spring, double temp, double r_equil, double r_cutoff2,
                                    double r_min_mag2,
                                    double *r_1, double *s_1, double *u_1, double length_1,
                                    double *r_2, double *s_2, double *u_2, double length_2);
void gaussj(double **a, int n, double **b, int m);
void *gcalloc(size_t n, size_t size);
void gcf(double *gammcf, double a, double x, double *gln);

void generate_body_frame(int n_dim, double *u, double *body_frame);

void generate_random_unit_vector(int n_dim, double *vect, gsl_rng *r);

FILE *gfopen(const char *file_name, const char *type);
void *gmalloc(size_t size);

void grabber(int width, int height, std::string fname, int framenum);
void *grealloc(void *ptr, size_t size);
void gser(double *gamser, double a, double x, double *gln);

void hermite(int max_order, double x, double *herm);
int **imatrix(long nrl, long nrh, long ncl, long nch);
void free_imatrix(int **m, long nrl, long nrh, long ncl, long nch);
void indexx(unsigned long n, double arr[], unsigned long indx[]);

void init_2d_line_list(int max_elements, line_list *list);

void init_anchor_structure(system_parameters *parameters,
                           system_properties *properties);

void init_bond_structure_sphere_sphero(system_parameters *parameters,
                                       system_properties *properties);

void init_bond_structure_sphero(system_parameters *parameters, system_properties *properties);

void init_child_bond_structure(system_parameters *parameters, system_properties *properties);

void init_correlation_struct(int n_dim, correlation_data *data);

void init_crosslink_sphero_bd(system_parameters *parameters,
                              system_properties *properties, system_potential *potential);

void init_crosslink_sphero_bd_mp(system_parameters *parameters,
                                 system_properties *properties, system_potential *potential);
void init_diffusion_analysis_free(system_parameters *parameters,
                                 system_properties *properties, system_potential *potential);
void init_xlink_analysis(system_parameters *parameters,
                         system_properties *properties, system_potential *potential);

void init_default_params(system_parameters *parameters);

void init_diffusion_sphero(system_parameters *parameters, system_properties *properties);
void configure_diffusion_sphero(system_parameters *parameters, system_properties *properties);

void init_dynamic_instability(system_parameters *parameters, system_properties *properties);

void init_potential_crosslink_sphero_bd(system_parameters *parameters,
                                        system_properties *properties,
                                        system_potential *potential);

void init_potential_crosslink_sphero_bd_mp(system_parameters *parameters,
                                           system_properties *properties,
                                           system_potential *potential);

void init_potential_spb_dynamics(system_parameters *parameters,
                               system_properties *properties,
                               system_potential *potential);

void init_potential_spindle_bd_mp(system_parameters *parameters,
                               system_properties *properties,
                               system_potential *potential);

void init_potential_sphero_bd(system_parameters *parameters, system_properties *properties,
                              system_potential *potential);

void init_potential_sphero_bd_mp(system_parameters *parameters, system_properties *properties,
                                 system_potential *potential);

void init_potential_sphero_movie(system_parameters *parameters,
                                 system_properties *properties,
                                 system_potential *potential);

void init_potential_spindle_bd_mp(system_parameters *parameters,
                                  system_properties *properties,
                                  system_potential *potential);

void init_site_structure_sphere_sphero(system_parameters *parameters,
                                       system_properties *properties);

void init_site_structure_sphero(system_parameters *parameters, system_properties *properties);

void init_spb_dynamics(system_parameters *parameters,
                     system_properties *properties,
                     system_potential *potential,
                     char *config_file);

void init_spindle_bd_mp(system_parameters *parameters,
                        system_properties *properties,
                        system_potential *potential);

void init_sphero_analysis(system_parameters *parameters,
                          system_properties *properties,
                          analysis_properties *analysis,
                          system_potential *potential);

void init_sphero_bd(system_parameters *parameters, system_properties *properties, 
                    system_potential *potential);

void init_sphero_bd_mp(system_parameters *parameters, system_properties *properties, 
                       system_potential *potential);

void init_sphero_movie(system_parameters *parameters,
                       system_properties *properties,
                       system_potential *potential);

void init_spindle_bd_mp(system_parameters *parameters,
                     system_properties *properties,
                     system_potential *potential);

void init_unit_cell_structure(system_parameters *parameters, system_properties *properties);

void insert_random_kc(int n_dim, double *r, double confining_diameter,
                      double kc_diameter, gsl_rng *rng);

void insert_random_mt(int n_dim, double *r_spb, double spb_dia,
		      double *u_mt, double *mt_theta, double *mt_phi, 
		      double length, double diameter, system_properties *properties);
int *ivector(long nl, long nh);
void free_ivector(int *v, long nl, long nh);
void jacobi(double **a, int n, double d[], double **v, int *nrot);

void lfit(double x[], double y[], double sig[], int ndat, double a[], int ia[],
          int ma, double **covar, double *chisq, void (*funcs) (double, double[], int));

int linear_index_row_major(int i_dim, int n_dim, int *i_grid, int *n_grid);

void local_order_cl(system_parameters *parameters, system_properties *properties);
void lubksb(double **a, int n, int *indx, double b[]);
void ludcmp(double **a, int n, int *indx, double *d);
unsigned long *lvector(long nl, long nh);
void free_lvector(unsigned long *v, long nl, long nh);
void matrix_inversion(int n, double **a, double **a_inv);

double motility_force_bd(system_parameters *parameters, system_properties *properties,
                         double **f_bond, double **virial, double **t_bond, int *calc_matrix);

double motility_force_bd_mp(system_parameters *parameters, system_properties *properties,
                            double **f_bond, double **virial, double **t_bond, int *calc_matrix);
void mrqcof(double x[], double y[], double sig[], int ndata, double a[], int ia[],
            int ma, double **alpha, double beta[], double *chisq,
            void (*funcs) (double, double[], double *, double[], int));
void mrqmin(double x[], double y[], double sig[], int ndata, double a[], int ia[],
            int ma, double **covar, double **alpha, double *chisq,
            void (*funcs) (double, double[], double *, double[], int), double *alamda);

double **norm_single_particle_dot_product_acf(int n_dim, int n_objs, int start_config,
                                              int n_configs, int n_acf, 
                                              int n_order, 
                                              off_t block_size, 
                                              off_t offset, 
                                              FILE *in_stream);

double **norm_single_particle_dot_product_acf_mmap(int n_dim, int n_objs, int start_config,
                                                   int n_configs, int n_acf, 
                                                   int n_order, 
                                                   off_t block_size, 
                                                   off_t offset, 
                                                   const char *in_file);

void normalize_correlation_data_g(correlation_data *data, correlation_data *g);

void normalize_correlation_data_unity(correlation_data *data);
void nrerror(const char* error_text);

void omp_set_schedule_str(char *str, int chunksize);

void optimize_skin(int n_opt, double delta, double *skin, double *skin_old,
                   double elapsed_time, double *md_efficiency);

void pair_correlation(int n_dim, int n_object, double **s, int *n_bin, double *pair_dist);


void pair_correlation_axes_2d(int n_dim, int n_objects, double **h, double **r, double **s, double **u, 
                              double delta_par, double delta_perp, double r_max, int *n_bin, double *pair_dist,
                              double *p1, double *p2);

void pair_correlation_axes_2d_single(double *dr, double *u_i, double *u_j, double uiuj, 
                                     double dr2, double delta_par, 
                                     double delta_perp, double r_max, 
                                     int *n_bin, double *pair_dist, double *p1, double *p2);

void pair_correlation_axes_3d(int n_dim, int n_objects, double **h, double **r, double **s, double **u, 
                              double delta_par, double delta_perp, double r_max, int *n_bin, double *pair_dist,
                              double *p1, double *p2);

void pair_correlation_axes_3d_single(double *dr, double *u_i, double *u_j, double uiuj, 
                                     double dr2, double delta_par, double delta_perp, 
                                     double r_max, int *n_bin, double *pair_dist, 
                                     double *p1, double *p2);

void pair_correlation_cl_axes_2d_single(double *dr, double *u_i, double *u_j, double delta_par, 
                                        double delta_perp, double r_max, double value, int *n_bin, 
                                        double *pair_dist_par);

void pair_correlation_radial(int n_dim, int n_objects, double **h, double **r, double **s, double **u,
                             double delta_r, int n_bin, double *pair_dist, double *p1, double *p2);

void pair_correlation_radial_single(int n_dim, double dr, double uiuj, double delta_r, 
                                    int n_bin, double *pair_dist,
                                    double *p1, double *p2);

void pair_correlation_single(int n_dim, double *ds, int *n_bin, double *pair_dist);

void pair_correlation_value_single(int n_dim, double *ds, int *n_bin, double value, double *pair_dist);

void pair_separation(int n_dim, int n_periodic, double **h,
                     double *r_1, double *s_1, double *r_2, double *s_2, double *dr);

int parallel_polar_difference(int i_bond, int j_bond,
                              system_parameters *parameters,
                              system_properties *properties);

void parallelepiped_bundle_insertion_sphero_periodic(system_parameters *parameters, int n_dim, 
                                                     int n_periodic, double **h, double **h_inv, 
                                                     int n_bonds, double diameter, int max_trials, 
                                                     gsl_rng *r_rng,
                                                     double **r, double **s,
                                                     double **r_bond, double **s_bond, 
                                                     double **u_bond, 
                                                     double *length,
                                                     int *site_1, int *site_2);

void parallelepiped_insertion_periodic(system_parameters *parameters, int n_dim, int n_sites, double **h,
                                       int max_trials, gsl_rng *r_rng, double dr_min,
                                       double **s, double **r);

void parallelepiped_insertion_sphero_periodic(system_parameters *parameters, int n_dim, int n_periodic, 
                                              double **h, double **h_inv, int n_bonds,
                                              double diameter, int max_trials, gsl_rng *r_rng,
                                              double **r, double **s, double **r_bond,
                                              double **s_bond, double **u_bond, double *length,
                                              int *site_1, int *site_2);

void parallelepiped_nematic_insertion_sphero_periodic(system_parameters *parameters, int n_dim, int n_periodic,
                                                      double **h, double **h_inv, int n_bonds,
                                                      double diameter, int max_trials, gsl_rng *r_rng,
                                                      double **r, double **s, double **r_bond,
                                                      double **s_bond, double **u_bond, double *length,
                                                      int *site_1, int *site_2, int sphere_flag);

void parallelepiped_square_insertion_sphero_periodic(system_parameters *parameters, int n_dim, 
                                                     int n_periodic, double **h, double **h_inv, 
                                                     int n_bonds, double diameter,
                                                     int max_trials, gsl_rng *r_rng,
                                                     double **r, double **s,
                                                     double **r_bond, double **s_bond, double **u_bond, 
                                                     double *length,
                                                     int *site_1, int *site_2);

int parse_param_cmd(system_parameters *parameters, char *line);

void parse_parameters(char *param_file, system_parameters *parameters);

void parse_parameters_node(YAML::Node node, system_parameters *parameters);

void parse_scaling_matrix(int n_periodic, char *scaling_file,
                          int **scaling_matrix, int *n_scaling_sets);

int parse_tokens(char *line, char ***token);

int parse_tokens_cmd(char *line, char ***token);

void periodic_boundary_conditions(int n_periodic, int n_objects, double **h, double **h_inv,
                                  double **r, double **s);

void periodic_boundary_conditions_single(int n_periodic, double **h, double **h_inv,
                                         double *r, double *s);

void position_step_bd(system_parameters *parameters, system_properties *properties,
                      system_potential *potential);

void position_step_bd_mp(system_parameters *parameters, system_properties *properties,
                         system_potential *potential);

void position_step_rigid_tether(system_parameters *parameters, system_properties *properties,
                                system_potential *potential);

void position_step_spb_dynamics(system_parameters *parameters, system_properties *properties,
                                system_potential *potential);

void position_step_spindle_bd_mp(system_parameters *parameters, system_properties *properties,
                                system_potential *potential);

void print_omp_settings();

int product_of_powers_of_2_3_5(int i, int *pow_2, int *pow_3, int *pow_5);

void purge_line_list(line_list *list);
double qsimp(double (*func) (double), double a, double b);

void read_config(system_parameters * parameters, system_properties * properties, char *config_file);

void read_header_spb_dynamics(system_parameters *parameters,
                               system_properties *properties, FILE * f_input);

void read_header_sphero(system_parameters *parameters,
                        system_properties *properties, FILE * f_input);

int read_input_dimension(system_properties *properties, FILE *f_input);

int read_positions(int n_dim, int n_sites, double **h, double **r, FILE * f_posit);
int read_positions_spindle(int n_dim, int n_sites, int n_anchors, 
                           double *time_s, double **h, double **r, 
                           double **r_a, double **uref_a, 
                           FILE * f_posit);

void update_spindle_state(system_parameters *parameters,
                          system_properties *properties);

int read_state_crosslinks(system_parameters *parameters, system_properties *properties,
                          FILE **f_crosslink);
void *realloc_1d_array(void *ptr, size_t n1, size_t size);
void **realloc_2d_array(void **ptr, size_t n1_old, size_t n1, size_t n2, size_t size);
void ***realloc_3d_array(void ***ptr, size_t n1_old, size_t n2_old, size_t n1, size_t n2, size_t n3,
                         size_t size);

void rotate_2d_mat_inplace(double theta, double **A);

void sample_velocities(int n_atoms, int n_dim, double temp, gsl_rng *r, double *m, double **v);

double **norm_single_particle_dot_product_acf(int n_dim, int n_objs, int start_config,
                                              int n_configs, int n_acf, 
                                              int n_order, 
                                              off_t block_size, 
                                              off_t offset, 
                                              FILE *in_stream);

double **single_particle_dot_product_acf(int n_dim, int n_objs, int start_config,
                                         int n_configs, int n_acf, 
                                         int n_order, 
                                         off_t block_size, 
                                         off_t offset, 
                                         FILE *in_stream);

double wca_sphero_wall_potential_bd(system_parameters *parameters, 
                                            system_properties *properties,
                                            double **f_bond, double **virial, 
                                            double **t_bond, int *calc_matrix);

double wca_cubic_wall_sphero_potential_bd(system_parameters *parameters, 
                                            system_properties *properties,
                                            double **f_bond, double **virial, 
                                            double **t_bond, int *calc_matrix);

int sphere_overlap(int n_dim, double sphere_diameter, double *r1, double *r2);

int sphere_sphero_overlap(int n_dim, int n_periodic, double **h, double skin, double diameter_12,
                          double *r_1, double *s_1,
                          double *r_2, double *s_2, double *u_2, double length_2);

double sphere_wall_potential_bd(system_parameters *parameters, system_properties *properties,
                                double **f, double **virial, double **t_bond, int *calc_matrix);
double kc_wall_wca_potential(system_parameters *parameters, system_properties *properties,
                                double **f, double **virial, double **t_bond, int *calc_matrix);

int sphere_sphero_overlap(int n_dim, int n_periodic, double **h, double skin, double diameter_12,
                          double *r_1, double *s_1,
                          double *r_2, double *s_2, double *u_2, double length_2);

int sphero_overlap(int n_dim, int n_periodic, double **h, double skin, double diameter_12,
                   double *r_1, double *s_1, double *u_1, double length_1,
                   double *r_2, double *s_2, double *u_2, double length_2);

double single_site_sphero_wall_potential_bd(system_parameters *parameters, 
                                            system_properties *properties,
                                            double **f_bond, double **virial, 
                                            double **t_bond, int *calc_matrix);

double sphero_wall_potential_bd(system_parameters *parameters,
                                system_properties *properties,
                                double **f_bond, 
                                double **virial, double **t_bond, int *calc_matrix);

void accum_dynamic_structure_factor(int n_dim, int n_linear, 
                                    int max_config, fftw_complex *out, 
                                    FILE *f_rho_k, FILE *f_scatter, int clear_flag);

void accum_structure_factor(int i_dim, int n_dim, int n_objects, int *i_bin, int *i_bin_shift,
                            int *n_bin, fftw_complex * out, double *struct_factor);

void structure_factor(int i_dim, int n_dim, int n_objects, int *i_bin, int *i_bin_shift, int *n_bin,
                      fftw_complex * out, double *struct_factor);

void extract_dynamic_structure_factor(int i_dim, int n_dim, double factor, int *i_bin,
                                      int *i_bin_shift, int *n_bin, fftw_complex * out,
                                      double *array);

void thermodynamics_sphero(system_parameters *parameters, system_properties *properties);
double trapzd(double (*func) (double), double a, double b, int n, double s);

void unit_cell_dimensions(int n_dim, double **h,
                          double **h_inv, double **a, double **b, double *a_perp, double *volume);

void update_2d_line_list(line_list *list, double *s_new);

void update_bond_positions(int n_dim, int n_periodic, int n_bonds, double **h, double **h_inv,
                           double **r, int *site_1, double **v_bond,
                           double **r_bond, double **s_bond);

void update_bond_site_positions(int n_dim, int n_periodic, int n_bonds, int n_sites, double **h,
                                double **h_inv, int *bond_site_1, int *bond_site_2, double **r_bond,
                                double **u_bond, double *length, double **r, double **s);

void update_bond_site_positions_mp(int n_dim, int n_periodic, int n_bonds, int n_sites, double **h,
                                   double **h_inv, int *bond_site_1, int *bond_site_2, double **r_bond,
                                   double **u_bond, double *length, double **r, double **s);

void update_bond_vectors(int n_dim, int n_periodic, int n_bonds, double **h,
                         double **s, double **r, int *site_1, int *site_2,
                         double **v_bond, double **u_bond, double *length, double *length2);

void update_child_positions(system_parameters *parameters, system_properties *properties);

void update_neighbor_lists_sphero(system_parameters *parameters, system_properties *properties);

void update_neighbor_lists_sphero_all_pairs(int n_dim, int n_periodic, double **h, 
                                            double skin, double diameter,
                                            int n_bonds, double **r, double **s, double **u, 
                                            double *length, nl_list *neighbs, 
                                            int nl_twoway_flag);

void update_neighbor_lists_sphero_all_pairs_mp(int n_dim, int n_periodic, double **h, 
                                               double skin, double diameter,
                                               int n_bonds, double **r, double **s, double **u, 
                                               double *length, nl_list *neighbs, 
                                               int nl_twoway_flag);

void update_neighbor_lists_sphero_cells(int n_dim, int n_periodic, double **h, double skin, 
                                        double r_cutoff, int n_bonds, 
                                        double **r, double **s, double **u, double *length,
                                        cell_list *cells, nl_list *neighbs, 
                                        int nl_twoway_flag);

void update_neighbor_lists_sphero_cells_mp(int n_dim, int n_periodic, double **h, double skin, 
                                           double r_cutoff, int n_bonds, 
                                           double **r, double **s, double **u, double *length,
                                           cell_list *cells, nl_list *neighbs, 
                                           int nl_twoway_flag);

void update_neighbor_lists_sphero_mp(system_parameters *parameters, system_properties *properties);

double wall_attach_potential_bd(system_parameters *parameters, system_properties *properties,
                                double **f_bond, double **virial, double **t_bond, int *calc_matrix);

void write_config(system_parameters *parameters,
                  system_properties *properties, char *config_file);

void write_config_kc_capture(system_parameters *parameters,
                             system_properties *properties,
                             char *config_file);

void write_config_spb_dynamics(system_parameters *parameters,
                               system_properties *properties,
                               char const *config_file);

void write_correlation_struct(correlation_data *data, const char outfile[]);
void write_header_kc_capture(int n_dim, int n_sites, int n_bonds, double **h, FILE *f_posit);

void write_header_spb_dynamics(system_parameters *parameters,
                                system_properties *properties, FILE * f_output);

void write_header_sphero(system_parameters *parameters,
                         system_properties *properties, FILE * f_output);

void write_positions(int n_dim, int n_sites, double **h, double **r, FILE * f_posit);

void write_positions_kc_capture(int n_dim, int n_sites, int n_bonds, double **r, 
                                double time, FILE * f_posit);

void write_positions_spb_dynamics(int n_dim, int n_sites, int n_bonds, int n_anchors,
                                  double **h, double **r, double **ra, double **ua, 
                                  double time, FILE * f_posit);

void write_positions_spindle_pole_body(system_parameters *parameters,
                                       system_properties *properties,
                                       FILE *fspb,
                                       bool& write_header);
void read_positions_spindle_pole_body(system_parameters *parameters,
                                       system_properties *properties,
                                       FILE *fspb);


void write_positions_sphero(int n_dim, int n_bonds, double **h, double **r,
                            double **u, double *length, FILE *f_posit);

void write_spindle(system_parameters *parameters,
                   system_properties *properties, 
                   system_potential *potential, 
                   FILE *f_spindle);

void write_state_crosslinks(system_parameters *parameters, system_properties *properties,
                            FILE **f_crosslink);

void write_thermo_sphero(system_parameters *parameters,
                         system_properties *properties, 
                         system_potential *potential, 
                         FILE *f_thermo);
void write_thermo_spindle(system_parameters *parameters,
                          system_properties *properties, 
                          system_potential *potential, 
                          FILE *f_thermo,
                          FILE *f_pole,
                          FILE *f_forces);

void zero_com_velocity(int n_sites, int n_dim, double *m, double **v);

void omp_set_schedule_str(char *str, int chunksize);
void set_omp_settings(system_parameters *parameters);
void print_omp_settings();
void grabber_color(int width, int height, char *fname,  double *color_vector);
double soft_sphero_wall_potential_bd(system_parameters *parameters, 
                                     system_properties *properties, 
                                     double **f_bond, double **virial,
                                     double **t_bond, int *calc_matrix); 
double linear_sphero_wall_potential_bd(system_parameters *parameters, 
                                     system_properties *properties, 
                                     double **f_bond, double **virial,
                                     double **t_bond, int *calc_matrix); 
double quadratic_sphero_wall_potential_bd(system_parameters *parameters, 
                                     system_properties *properties, 
                                     double **f_bond, double **virial,
                                     double **t_bond, int *calc_matrix); 
double NM_sphero_wall_potential_bd(system_parameters *parameters, 
                                     system_properties *properties, 
                                     double **f_bond, double **virial,
                                     double **t_bond, int *calc_matrix); 
int find_wall_potential_index(system_parameters *parameters, system_potential *potential);
void invert_sym_2d_matrix(double *a, double *b);
void invert_sym_3d_matrix(double *a, double *b);
