/* This routine reads a single configuration (unit cell matrix and site positions and velocities)
   from an input file.

   Input: pointer to parameters structure (parameters)
          pointer to properties structure (properties)
          name of configuration file (config_file)

   Output: a single configuration is read from the configuration file */

#include "bob.h"

void read_config(system_parameters * parameters, system_properties * properties, char *config_file)
{
    FILE *f_config;
    int n_dim, n_sites, i, i_site;
    double **h, **r, **v;

    /* Print message to standard output. */
    fprintf(stdout, "reading initial configuration from %s:\n\n", config_file);

    /* Open input file. */
    f_config = gfopen(config_file, "r");

    /* Read header from input file. */
    properties->read_header_func(parameters, properties, f_config);
    n_dim = parameters->n_dim;
    n_sites = properties->sites.n_sites;

    /* Allocate memory for unit cell matrix and position and velocity arrays. */
    h = properties->unit_cell.h = (double **) allocate_2d_array(n_dim, n_dim, sizeof(double));
    r = properties->sites.r = (double **) allocate_2d_array(n_sites, n_dim, sizeof(double));
    v = properties->sites.v = (double **) allocate_2d_array(n_sites, n_dim, sizeof(double));

    /* Read unit cell matrix from input file. */
    for (i = 0; i < n_dim; ++i)
        fread(h[i], sizeof(double), n_dim, f_config);

    /* Read site positions and velocities from input file. */
    for (i_site = 0; i_site < n_sites; ++i_site) {
        fread(r[i_site], sizeof(double), n_dim, f_config);
        fread(v[i_site], sizeof(double), n_dim, f_config);
    }

    /* Close input file. */
    fclose(f_config);
    fprintf(stdout, "\n");

    return;
}
