/* This routine reads header information for the hard sphere Monte Carlo simulation
 from an input file.
 
 Input: pointer to parameters structure (parameters)
 pointer to properties structure (properties)
 pointer to input file (f_input)
 
 Output: header information is read from the input file */

#include "bob.h"

void read_header_spb_dynamics(system_parameters * parameters,
                               system_properties * properties, FILE * f_input)
{
    int n_dim, n_spheres, n_spheros, n_anchors, n_objects, n_sites, n_bonds;

    /* Read in number of spatial dimensions, number of spheres, number of spherocylinders, the ghost sphere flag, and the spherocylinder length. */
    n_dim = read_input_dimension(properties, f_input);
    fread(&n_spheres, sizeof(int), 1, f_input);
    fread(&n_spheros, sizeof(int), 1, f_input);
    fread(&n_anchors, sizeof(int), 1, f_input);
    parameters->n_dim = n_dim;
    parameters->n_spheres = n_spheres;
    parameters->n_spheros = n_spheros;
    parameters->n_anchors = n_anchors;
    n_objects = n_spheres + n_spheros + n_anchors;
    n_sites = properties->sites.n_sites = n_spheres + 2 * n_spheros;
    n_bonds = properties->bonds.n_bonds = n_spheros;
    fprintf(stdout, "   n_dim = %d\n", n_dim);
    fprintf(stdout, "   n_spheres = %d\n", n_spheres);
    fprintf(stdout, "   n_spheros = %d\n", n_spheros);
    fprintf(stdout, "   n_anchors = %d\n", n_anchors);
    fprintf(stdout, "   n_objects = %d\n", n_objects);
    fprintf(stdout, "   n_sites = %d\n", n_sites);
    fprintf(stdout, "   n_bonds = %d\n", n_bonds);
    fflush(stdout);

    return;
}
