/* This routine reads header information for the hard sphere Monte Carlo simulation
 from an input file.
 
 Input: pointer to parameters structure (parameters)
 pointer to properties structure (properties)
 pointer to input file (f_input)
 
 Output: header information is read from the input file */

#include "bob.h"

void read_header_sphero(system_parameters * parameters,
                        system_properties * properties, FILE * f_input)
{
    int n_dim, n_bonds, n_sites;

    /* Read in number of spatial dimensions and number of bonds. */
    n_dim = read_input_dimension(properties, f_input);
    fread(&n_bonds, sizeof(int), 1, f_input);
    parameters->n_dim = n_dim;
    properties->bonds.n_bonds = n_bonds;
    n_sites = properties->sites.n_sites = 2 * n_bonds;
    fprintf(stdout, "   n_dim = %d\n", n_dim);
    fprintf(stdout, "   n_bonds = %d\n", n_bonds);
    fprintf(stdout, "   n_sites = %d\n", n_sites);
    fflush(stdout);

    return;
}
