// Implementation of the reader for spindle pole bodies themselves

#include "bob.h"

#include <iostream>

void read_positions_spindle_pole_body(system_parameters *parameters,
                                      system_properties *properties,
                                      FILE *fspb) {
    // Read off the header and check it
    int nanchors;
    fread(&nanchors, sizeof(int), 1, fspb);
    //std::cout << "found " << nanchors << " anchors compared to " << properties->anchors.n_anchors << std::endl;
    if (nanchors != (int) properties->anchors.n_anchors) {
        std::cerr << "Mistmatch number of spindle pole bodies, exiting\n";
        exit(1);
    }

    for (int ispb = 0; ispb < nanchors; ++ispb) {
        int nattachments;
        fread(&nattachments, sizeof(int), 1, fspb);
        //std::cout << "spb" << ispb << " attachments: " << nattachments << " vs " << properties->anchors.anchor_list[ispb].size() << std::endl;
        if (nattachments != (int) properties->anchors.anchor_list[ispb].size()) {
            std::cerr << "Mismatch number of microtubules allocated to spb, exiting\n";
            exit(1);
        }

        for (int ia = 0; ia < nattachments; ++ia) {
            int label;
            fread(&label, sizeof(int), 1, fspb);

            for (int i = 0; i < 3; ++i) {
                float tmp;
                fread(&tmp, sizeof(float), 1, fspb);
                properties->anchors.anchor_list[ispb][ia].pos_rel[i] = tmp;
            }
            for (int i = 0; i < 3; ++i) {
                float tmp;
                fread(&tmp, sizeof(float), 1, fspb);
                properties->anchors.anchor_list[ispb][ia].u_rel[i] = tmp;
            }
        }
    }

    // Now comes the fun part, as we must read in and convert all of the spindle pole body orientation information
    // r, u, v, w
    // Write the relevant information for each spindle pole body
    for (int ispb = 0; ispb < properties->anchors.n_anchors; ++ispb) {
        double *r_anchor = properties->anchors.r_anchor[ispb];
        double *u_anchor = properties->anchors.u_anchor[ispb];
        double *v_anchor = properties->anchors.v_anchor[ispb];
        double *w_anchor = properties->anchors.w_anchor[ispb];
        
        for (int i = 0; i < 3; ++i) {
            float tmp;
            fread(&tmp, sizeof(float), 1, fspb);
            r_anchor[i] = tmp;
        }
        for (int i = 0; i < 3; ++i) {
            float tmp;
            fread(&tmp, sizeof(float), 1, fspb);
            u_anchor[i] = tmp;
        }
        for (int i = 0; i < 3; ++i) {
            float tmp;
            fread(&tmp, sizeof(float), 1, fspb);
            v_anchor[i] = tmp;
        }
        for (int i = 0; i < 3; ++i) {
            float tmp;
            fread(&tmp, sizeof(float), 1, fspb);
            w_anchor[i] = tmp;
        }
    }
}
