// Spatial helpers functions for use in bob
// Useful for 3d things, etc
// Especially in the ugly as fuck graphics code

#ifndef _SPATIAL_HELPERS_H_
#define _SPATIAL_HELPERS_H_

// Axis angle functions
void create_axisangle(double *theta, double *eaxis, double *a, double *b);
void axisangle_from_quaternion(double *theta, double *eaxis, double *q);

// quaternion functions
void quaternion_from_axisangle(double *q, double theta, double *eaxis);
void quaternion_between_vectors(double *q, double *a, double *b);
void quaternion_multiply(double *t, double *q, double *r);
double quaternion_norm(double *q);
void normalize_quaternion(double *q);

// Rotation functions
void rodrigues_axisangle(double *vrot, double *v, double theta, double *e);
void rotate_towards(double *q1, double *q2, float maxAngle, double *q);

// Print functionality
void print_quaternion(double *q);

#endif
