#include "bob.h"

#include <iostream>

double spb_spring_potential_angular(system_parameters *parameters, system_properties *properties,
                                    double **f_bond, double **virial, double **t_bond, int *calc_matrix) {
    int i, i_bond, i_anchor, n_anchors, n_dim, n_bonds;
    double u, kr, dr[3], *pos;
    double *origin;
    double **r_bond, **r_anchor, **f_anchor, **tau_local, *length, **u_bond;

    n_dim = parameters->n_dim;
    n_bonds = properties->bonds.n_bonds;
    r_bond = properties->bonds.r_bond;
    length = properties->bonds.length;
    u_bond = properties->bonds.u_bond;
    n_anchors = properties->anchors.n_anchors;
    f_anchor = properties->anchors.f_anchor;
    r_anchor = properties->anchors.r_anchor;
    tau_local = properties->anchors.tau_local;
    al_list *anchor_list = properties->anchors.anchor_list;
    
    if (n_dim != 3) {
        error_exit("anchor_potential_bd only supports 3 dimensions");
    }

    /* Zero vdw forces, potential energy and virial. */
    u = 0.0;
    if (properties->control.virial_flag)
        memset(virial[0], 0, n_dim * n_dim * sizeof(double));
    memset(f_bond[0], 0, n_bonds * n_dim * sizeof(double));
    memset(t_bond[0], 0, n_bonds * 3 * sizeof(double));
   
    for (i_anchor = 0; i_anchor < n_anchors; ++i_anchor) {
        kr = properties->anchors.kr[i_anchor];

        if (kr == 0.0)
            continue;

        for (al_list::iterator p = anchor_list[i_anchor].begin();
                p < anchor_list[i_anchor].end();
                p++) {
            i_bond = p->label;
            pos = p->pos;

            // Print out the anchor information in debug
            //std::cout << "attachment u: [" << p->u[0] << ", " << p->u[1] << ", " << p->u[2] << "]\n";
            //std::cout << "spb        u: [" << properties->anchors.u_anchor[i_anchor][0] << ", "
            //                               << properties->anchors.u_anchor[i_anchor][1] << ", "
            //                               << properties->anchors.u_anchor[i_anchor][2] << "]\n";
            //std::cout << "bond       u: [" << u_bond[i_bond][0] << ", " << u_bond[i_bond][1] << ", " << u_bond[i_bond][2] << "]\n";

            // The anchor has the information on the orientation that we like
            double dot_prod = dot_product(n_dim, u_bond[i_bond], p->u);
            if (dot_prod > 1.0) dot_prod = 1.0;
            double theta = acos(dot_prod);
            double nhat[3] = {0.0};
            cross_product(u_bond[i_bond], p->u, nhat, n_dim);
            double tau_factor = -theta * kr;

            //std::cout << "theta: " << theta << std::endl;
            //std::cout << "tau_factor: " << tau_factor << std::endl;
            //std::cout << "nhat: [" << nhat[0] << ", " << nhat[1] << ", " << nhat[2] << "]\n";
            double nhatnorm = dot_product(n_dim, nhat, nhat);
            //std::cout << "nhatnorm: " << nhatnorm << std::endl;
            if (nhatnorm <= 0.0) nhatnorm = 1.0;
            for (int i = 0; i < 3; ++i) {
                nhat[i] = nhat[i] / sqrt(nhatnorm);
            }

            for (int i = 0; i < n_dim; ++i) {
                t_bond[i_bond][i] -= tau_factor * nhat[i];
                tau_local[i_anchor][i] += tau_factor * nhat[i];
            }

            u += 0.5 * kr * theta * theta;

            if (u != u) {
                std::cerr << "NaN encountered in spb_spring_potential_angular\n";
                std::cerr << "Step: " << properties->i_current_step << std::endl;
                std::cerr << "SPB: " << i_anchor << ", bond: " << i_bond << std::endl;
            }
        }
    }

    return u;
}
